<div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Financial Summary 
                                ( 
                                <?php
                                    $range = $daterange[0] ?? null;
                                ?>

                                <!--[if BLOCK]><![endif]--><?php if(!empty($range['startDate']) && !empty($range['endDate'])): ?>
                                    <?php echo e(\Carbon\Carbon::parse($range['startDate'])->format('m/d/Y')); ?> - <?php echo e(\Carbon\Carbon::parse($range['endDate'])->format('m/d/Y')); ?>

                                <?php elseif(!empty($range['year'])): ?>
                                    <?php echo e($range['year']); ?>

                                <?php else: ?>
                                    No date range selected
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                 )

                        </h4>
                    </div>
                    
                </div>
            </div>

            <div class="col-12">
              <div class="row">
                <div class="col-md-4">
                    <div class="card info-card customers-card">
                        <div class="card-body" style='padding:0 0px 10px 0px;'>
                            <h5 class="card-title" style="font-size:14px;text-align:center;background:#4d5cea;color:#fff;border-radius:0 0px 15px 15px;padding:10px!important;">
                                Total Billing Amount </h5>
                            <h6>
                                <center class="summaryamount">$ <?php echo e(number_format($totalBillAmount, 2)); ?></center>
                            </h6>
                            <!-- Table with stripped rows -->
                        </div>
                    </div>
                </div>


                <div class="col-md-4">
                    <div class="card info-card customers-card">
                        <div class="card-body" style='padding:0 0px 10px 0px;'>
                            <h5 class="card-title" style="font-size:14px;text-align:center;background:#4dea96;color:#fff;border-radius:0 0px 15px 15px;padding:10px!important;">
                                Paid Amount </h5>
                            <h6>
                                <center class="summaryamount">$ <?php echo e(number_format($paidBillAmount, 2)); ?></center>
                            </h6>
                            <!-- Table with stripped rows -->
                        </div>
                    </div>
                </div>


                <div class="col-md-4">
                    <div class="card info-card customers-card">
                        <div class="card-body" style='padding:0 0px 10px 0px;'>
                            <h5 class="card-title" style="font-size:14px;text-align:center;background:#e74848;color:#fff;border-radius:0 0px 15px 15px;padding:10px!important;">
                                Unpaid Amount </h5>
                            <h6>
                                <center class="summaryamount">$ <?php echo e(number_format($unpaidBillAmount, 2)); ?></center>
                            </h6>
                            <!-- Table with stripped rows -->
                        </div>
                    </div>
                </div>

              </div>

              <div class="row">

                 <!-- Filters -->
                    <div class="accordion col-12 mt-3" id="accordionExample">
                        <div class="accordion-item border-primary">
                            <h2 class="accordion-header">
                                <button class="accordion-button bg-primary text-white" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseOne">
                                    Graphical Summary
                                </button>
                            </h2>
                            <div id="collapseOne" class="accordion-collapse collapse show">
                                <div class="accordion-body">
                                    <div class="row">
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = [
                                            'thismonth' => 'This Month',
                                            'lastmonth' => 'Last Month',
                                            'thisyear' => 'This Year',
                                            'lastyear' => 'Last Year',
                                        ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class='col-md-2'>
                                            <a href="?showgraph=<?php echo e($val); ?>"
                                                class="btn <?php echo e(request('showgraph') == $val || (empty(request('showgraph')) && $val == 'thismonth') ? 'btn-primary' : 'btn-outline-primary'); ?>"
                                                style="width:100%"><?php echo e($label); ?></a>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

                                        <div class="col-md-4">
                                            <form method="get" class="d-flex gap-2">
                                                <input type="hidden" name="showgraph" value="customgraph">
                                                <select name="filter_month" class="form-control">
                                                    <option value="">Month</option>
                                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = range(1, 12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($m); ?>" <?php echo e(request('filter_month') == $m ? 'selected' : ''); ?>>
                                                            <?php echo e(\Carbon\Carbon::create()->month($m)->format('F')); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                </select>
                                                <select name="filter_year" class="form-control">
                                                <option value="">Year</option>
                                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = range(now()->year, now()->year - 9); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $y): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($y); ?>" <?php echo e(request('filter_year') == $y ? 'selected' : ''); ?>>
                                                <?php echo e($y); ?>

                                                </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                </select>

                                                
                                                <button class="btn btn-primary">Filter</button>
                                            </form>
                                        </div>
                                    </div>

                                    <!-- Chart and table would go here -->
                                    <div id="lineChart" class="mt-4"></div>
                                   <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
                                    <script>
                                        document.addEventListener("DOMContentLoaded", () => {
                                            const amounts = <?php echo json_encode($chartAmounts, 15, 512) ?>;
                                            const completedFiles = <?php echo json_encode($chartDataCompleteCount, 15, 512) ?>;

                                            // Calculate average per invoice for each point
                                            const avgInvoiceAmounts = amounts.map((amt, i) => {
                                                return completedFiles[i]
                                                    ? Number((amt / completedFiles[i]).toFixed(2))
                                                    : 0;
                                            });

                                            const chart = new ApexCharts(document.querySelector("#lineChart"), {
                                                series: [
                                                    {
                                                        name: "Amount $",
                                                        data: <?php echo json_encode($chartAmounts, 15, 512) ?>
                                                    },
                                                    {
                                                        name: "Created Files",
                                                        data: <?php echo json_encode($chartDataCount, 15, 512) ?>
                                                    },
                                                    {
                                                        name: "Completed Files",
                                                        data: <?php echo json_encode($chartDataCompleteCount, 15, 512) ?>
                                                    },
                                                    {
                                                        name: "Average Invoice Amount $",
                                                        data: avgInvoiceAmounts
                                                    }
                                                ],
                                                chart: {
                                                    height: 350,
                                                    type: 'line',
                                                    zoom: { enabled: true }
                                                },
                                                dataLabels: { enabled: false },
                                                stroke: { curve: 'straight' },
                                                grid: {
                                                    row: { colors: ['#f3f3f3', 'transparent'], opacity: 0.5 }
                                                },
                                                xaxis: {
                                                    categories: <?php echo json_encode($chartDates, 15, 512) ?>,
                                                }
                                            });

                                            chart.render();
                                        });

												

                                    </script>


                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End Accordion -->


 <div class="row" style="    margin-top: 1%;">

 <div class="col-md-8">
      <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Month to Month Graphical Summary</h4>
                    </div>
                                    <div id="monthpieChart" class="mt-4"></div>


                </div>

    

        <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Month to Month Summary</h4>
                    </div>
              
                  <?php $i = 1; ?>
              <!--[if BLOCK]><![endif]--><?php if(!empty($Monthtomonthdata)): ?>
              <div >
                    <table class='table table-striped datatable dataTable'>
                    <thead>
                    <tr>
                    <th>#</th>
                    <th>Month</th>
                      <th>Total Billed Assignment</th>
                        <th>Total Billing Amount</th>
                         <th>Total Paid Amount</th>
                          <th>Total Unpaid  Amount</th>
                        <th>Total Supplements Billed</th>
                    </tr>
                    </thead>
                    <tbody>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $Monthtomonthdata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $insData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                    <td><strong><?php echo e($i++); ?></strong></td>
                     <td><?php echo e(\Carbon\Carbon::createFromDate($insData['year'], $insData['month'], 1)->format('F Y')); ?></td>
        <td><?php echo e($insData['total_files']); ?></td>
        <td>$<?php echo e(number_format($insData['total_invoice_amount'], 2)); ?></td>
        <td>$<?php echo e(number_format($insData['total_paid_amount'], 2)); ?></td>
        <td>$<?php echo e(number_format($insData['total_invoice_amount'] - $insData['total_paid_amount'], 2)); ?></td>
                        <td><?php echo e($insData['supplement_count']); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                    </table>
                </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->


                </div>

    

   </div>

  <div class="col-md-4">
      <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Date wise File Open & Completed</h4>
                    </div>
                     <div >

                    <!--[if BLOCK]><![endif]--><?php if(!empty($chartDates)): ?>
                    <?php
                    $totalCreated = array_sum($chartDataCount);
                    $totalSupp = array_sum($chartDataSuppCount);
                    $totalCompleted = array_sum($chartDataCompleteCount);

                    ?>

                    <table class='table table-striped datatable dataTable'>
                    <thead>
                    <tr>
                    <th>#</th>
                    <th>Date</th>
                    <th>Files Created</th>
                    <th>Files Completed</th>
                        <th>Supplements</th>
                    </tr>
                    </thead>
                    <tbody>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $chartDates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                     <td><strong><?php echo e($loop->iteration); ?></strong></td>
                    <td><strong><?php echo e($date); ?></strong></td>
                    <td><?php echo e($chartDataCount[$key] ?? 0); ?></td>
                    <td><?php echo e($chartDataCompleteCount[$key] ?? 0); ?></td>
                        <td><?php echo e($chartDataSuppCount[$key] ?? 0); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

                    </tbody>
                    <tfoot>
                    <tr><th></th>
                    <th>Total</th>
                    <th><?php echo e($totalCreated); ?></th>
                    <th><?php echo e($totalCompleted); ?></th>
                        <th><?php echo e($totalSupp); ?></th>
                    </tr>
                    </tfoot>

                    </table>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>

                </div>

                   

              </div>
            </div>


        </div>

                <div class="row">

                    <div class="col-md-12">
                        <style>
                            .tablespan{ display: inline-block;     width: 100px;        padding: 4px 8px;        text-align: center;     border-radius: 4px;    }
                        </style>

                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Office Cycle Time</h4>
                            </div>

                            <?php   $i = 1; ?>

                            <div class="card-body" >

                                <table class='table table-striped datatable dataTable'>
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Office</th>
                                        <th> Cycle Time</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $averagecycletime; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <?php  $avg = round($row->avg_cycle_days, 2);

                            if ($avg <= 5) {
                            $bg = 'bg-success text-white'; // green
                            }
                            else if ($avg <= 10) {
                            $bg = 'bg-primary text-white'; // blue
                            }
                             elseif ($avg <= 15) {
                            $bg = 'bg-warning text-dark';  // yellow
                            } else {
                            $bg = 'bg-danger text-white';  // red
                            }
                                        ?>

                                        <tr>
                                            <td><strong><?php echo e($i++); ?></strong></td>
                                            <td><?php echo e($row->officecode); ?> - <?php echo e($row->officename); ?></td>
                                            <td ><b class="tablespan <?php echo e($bg); ?>"><?php echo e($avg); ?> Days</b></td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </tbody>
                                </table>
                            </div>


                        </div>



                    </div>



                </div>

            </div>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>

      document.addEventListener("DOMContentLoaded", () => {
                                            const chartnew = new ApexCharts(document.querySelector("#monthpieChart"), {
                                                series: [
                                                    {
                                                        name: "Total Files Billed",
                                                        data: <?php echo json_encode($chartmonthFiles, 15, 512) ?>
                                                    },
                                                    {
                                                        name: "Invoice Amount $",
                                                        data: <?php echo json_encode($chartmonthInvoice, 15, 512) ?>
                                                    },
                                                    {
                                                        name: "Paid Amount $",
                                                        data: <?php echo json_encode($chartmonthPaid, 15, 512) ?>
                                                    },
                                                    {
                                                        name: "Unpaid Amount $",
                                                        data: <?php echo json_encode($chartmonthUnpaid, 15, 512) ?>
                                                    },
                                                    {
                                                        name: "Supplement Count",
                                                        data: <?php echo json_encode($chartmonthSupplement, 15, 512) ?>
                                                    }
                                                ],
                                                chart: {
                                                    height: 350,
                                                    type: 'line',
                                                    zoom: { enabled: true }
                                                },
                                                dataLabels: { enabled: false },
                                                stroke: { curve: 'straight' },
                                                grid: {
                                                    row: { colors: ['#f3f3f3', 'transparent'], opacity: 0.5 }
                                                },
                                                xaxis: {
                                                    categories: <?php echo json_encode($chartmonthLabels, 15, 512) ?>,
                                                }
                                            });

                                            chartnew.render();
                                        });


/*
    const ctx = document.getElementById('monthpieChart').getContext('2d');

    const monthChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: <?php echo json_encode($chartmonthLabels); ?>,
            datasets: [
                {
                    label: 'Total Files',
                    data: <?php echo json_encode($chartmonthFiles); ?>,
                    borderColor: '#4e73df',
                    backgroundColor: 'transparent',
                    tension: 0.3
                },
                {
                    label: 'Invoice Amount',
                    data: <?php echo json_encode($chartmonthInvoice); ?>,
                    borderColor: '#1cc88a',
                    backgroundColor: 'transparent',
                    tension: 0.3
                },
                {
                    label: 'Paid Amount',
                    data: <?php echo json_encode($chartmonthPaid); ?>,
                    borderColor: '#36b9cc',
                    backgroundColor: 'transparent',
                    tension: 0.3
                },
                {
                    label: 'Unpaid Amount',
                    data: <?php echo json_encode($chartmonthUnpaid); ?>,
                    borderColor: '#f6c23e',
                    backgroundColor: 'transparent',
                    tension: 0.3
                }
            ]
        },
        options: {
            responsive: true,
            plugins: {
                title: {
                    display: true,
                    text: 'Month-to-Month Report Chart'
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return '$' + value;
                        }
                    }
                }
            }
        }
    });
    */
</script><?php /**PATH /Applications/MAMP/htdocs/exec-legacy-claims/resources/views/livewire/summary.blade.php ENDPATH**/ ?>