<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Activity</h4>
                </div>
                <div class="card-body">
                    <form  wire:submit.prevent="search" class="row">
                        <div class="col-md-6">
                            <label>Date Range</label>
                            <div class="row">
                                <div class="col-md-6">
                                    <input type="date" name="from_date" id="from_date" class="form-control" wire:model="from_date" value="<?php echo e(old('from_date')); ?>">
                                </div>
                                <div class="col-md-6">
                                    <input type="date" name="to_date" class="form-control" id="to_date" wire:model="to_date" value="<?php echo e(old('to_date')); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 pt-3" style="text-align:left;">
                            <button type="submit" class="btn btn-primary">Run Report</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
          
        <div class="col-12">
            <div class="row">
              <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Admin Activity Report</h4>
                        </div>
                          
                        <div >
                            <table class='table table-striped datatable dataTable'>
                                <thead>
                                    <tr>
                                        <th>S.No</th>
                                        <th>Name</th>
                                        <th>Activity Type</th>
                                        <th>Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($activities->firstItem() + $index); ?></td>
                                        <td><?php echo e($item->user->name); ?>

                                    <?php
                                    $roleMap = [  1 => 'Admin',2 => 'Appraiser',4 => 'Adjuster'];
                                    ?>

                                     - <?php echo e($roleMap[$item->user->role] ?? ''); ?>


                                         </td>
                                        <td><?php echo e($item->activity); ?></td>
                                        <td><?php echo e(date('d-M-Y H:i:s A', $item->log_date)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="4" style="text-align:center;">No activity data found.</td>
                                    </tr>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </tbody>
                            </table>
                            <?php echo e($activities->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH /Applications/MAMP/htdocs/exec-legacy-claims/resources/views/livewire/admin-activity.blade.php ENDPATH**/ ?>