<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoices</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 9px; /* smaller font = more rows per page */
            margin: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 9px;
            table-layout: fixed;
            word-wrap: break-word;
        }
        th, td {
            border: 1px solid #000;
            padding: 2px 3px;
            text-align: left;
        }
        th {
            background: #f2f2f2;
        }
        .page-break { 
            page-break-after: always; 
        }
        .header {
            width: 100%;
            margin-bottom: 10px;
        }
        .company-info {
            font-size: 11px;
            line-height: 1.4;
        }
    </style>
</head>
<body>

    
    <table class="header" style="border:0px!important;">
        <tr>
            <td style="border:none!important;width:50%;text-align:center;">
                <img src="https://lcsinsight.com/assets/img/company-logo-second.png" 
                     style="width: 175px;">
            </td>
            <td style="border:none!important;width:50%;text-align:left;" class="company-info">
                <strong>Legacy Claims Services</strong><br/>
                5184 Caldwell Mill Road, Suite 204-230,<br/>
                Birmingham, Alabama 35244<br/>
                Email: claims@legacyclaimservices.com<br/>
                Phone: (800) 780-1699
            </td>
        </tr>
    </table>

    <h3>Invoice Report</h3>
    <div>Generated at: <?php echo e($generated_at); ?></div>
    <div>Total invoices: <?php echo e($invoices->count()); ?></div>
    <br/>

    
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>File#</th>
                <th>Invoice #</th>
                <th>Owner Name</th>
                <th>Office</th>
                <th>Insurance</th>
                <th>Bulk Paying?</th>
                <th>Claim #</th>
                <th>Policy #</th>
                <th>Invoice Date</th>
                <th>Total</th>
                <th>Tax</th>
                <th>Amount Paid</th>
                <th>Balance</th>
            </tr>
        </thead>
        <tbody>
            <?php	
                $invloop = 0; 
                $totalinvoiceAmount = 0;
                $totalTaxAmount = 0;
                $totalpaidAmount = 0;
            ?>

            <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $taxAmount = (!empty($inv->finaltotal) && !empty($inv->taxpercentage))
                        ? ($inv->finaltotal * $inv->taxpercentage) / 100
                        : 0;

                    $balance = $inv->finaltotal + $taxAmount - $inv->amount_paid;
                    $ownerName = trim($inv->business_first_name . ' ' . $inv->business_last_name);

                    $totalinvoiceAmount += $inv->finaltotal;
                    $totalTaxAmount += $taxAmount;
                    $totalpaidAmount += $inv->amount_paid;

                    $invloop++;
                ?>

                <tr>
                    <td><?php echo e($invloop); ?></td>
                    <td><?php echo e($inv->file_no); ?></td>
                    <td><?php echo e($inv->invoiceno); ?></td>
                    <td><?php echo e($ownerName); ?></td>
                    <td><?php echo e($inv->officename); ?></td>
                    <td><?php echo e($inv->insurancecompanyname); ?></td>
                    <td><?php echo e($inv->paying_type == 'single' ? 'NO' : 'YES'); ?></td>
                    <td><?php echo e($inv->claim_number); ?></td>
                    <td><?php echo e($inv->policy_number); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($inv->gen_date)->format('m-d-Y')); ?></td>
                    <td>$<?php echo e(number_format($inv->finaltotal, 2)); ?></td>
                    <td>$<?php echo e(number_format($taxAmount, 2)); ?></td>
                    <td>$<?php echo e(number_format($inv->amount_paid, 2)); ?></td>
                    <td>$<?php echo e(number_format($balance, 2)); ?></td>
                </tr>

                
                <?php if($loop->iteration % 40 == 0): ?>
                    </tbody>
                </table>
                <div class="page-break"></div>
                <table>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>File#</th>
                            <th>Invoice #</th>
                            <th>Owner Name</th>
                            <th>Office</th>
                            <th>Insurance</th>
                            <th>Bulk Paying?</th>
                            <th>Claim #</th>
                            <th>Policy #</th>
                            <th>Invoice Date</th>
                            <th>Total</th>
                            <th>Tax</th>
                            <th>Amount Paid</th>
                            <th>Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                <?php endif; ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            
            <tr>
                <td colspan="10" align="right"><strong>Total :</strong></td>
                <td><strong>$<?php echo e(number_format($totalinvoiceAmount, 2)); ?></strong></td>
                <td><strong>$<?php echo e(number_format($totalTaxAmount, 2)); ?></strong></td>
                <td><strong>$<?php echo e(number_format($totalpaidAmount, 2)); ?></strong></td>
                <td><strong>$<?php echo e(number_format(($totalinvoiceAmount + $totalTaxAmount) - $totalpaidAmount, 2)); ?></strong></td>
            </tr>
        </tbody>
    </table>

</body>
</html>
<?php /**PATH /Applications/MAMP/htdocs/exec-legacy-claims/resources/views/pdf/exportreceivablepdf.blade.php ENDPATH**/ ?>