<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\RoutesController;

// Guest routes
Route::middleware('guest')->group(function () {
    Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [LoginController::class, 'login']);
});

// Authenticated routes
Route::middleware('auth')->group(function () {
    Route::get('/', [RoutesController::class, 'dashboard'])->name('dashboard');
    Route::get('/summary', [RoutesController::class, 'summary'])->name('summary');
    Route::get('/receivables', [RoutesController::class, 'receivables'])->name('receivables');
    Route::get('/client-kpi', [RoutesController::class, 'ClientKpi'])->name('client-kpi');
    Route::get('/admin-activity', [RoutesController::class, 'AdminActivity'])->name('admin-activity');
    Route::get('/multi-report', [RoutesController::class, 'MultiReport'])->name('multi-report');
    Route::get('/report-stage-lifecycle', [RoutesController::class, 'ReportStageLifecycle'])->name('report-stage-lifecycle');
    Route::get('/report-assignment-perday', [RoutesController::class, 'ReportAssignmentPerday'])->name('report-assignment-perday');
    Route::get('/report-assignment-cycletime', [RoutesController::class, 'ReportAssignmentCycletime'])->name('report-assignment-cycletime');
    Route::get('/report-average-cycletime', [RoutesController::class, 'ReportAverageCycletime'])->name('report-average-cycletime');
    Route::get('/report-average-invoicereport', [RoutesController::class, 'ReportAverageInvoicereport'])->name('report-average-invoicereport');
    Route::get('/file-aged-report', [RoutesController::class, 'FileAgedReport'])->name('file-aged-report');
    Route::get('/appraiser-report', [RoutesController::class, 'AppraiserReport'])->name('appraiser-report');
    Route::get('/client-health', [RoutesController::class, 'ClientHealth'])->name('client-health');
    Route::get('/tax-report', [RoutesController::class, 'TaxReport'])->name('tax-report');
    
    Route::post('/logout', [LoginController::class, 'logout'])->name('logout');
});
