<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoices</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 9px; /* smaller font = more rows per page */
            margin: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 9px;
            table-layout: fixed;
            word-wrap: break-word;
        }
        th, td {
            border: 1px solid #000;
            padding: 2px 3px;
            text-align: left;
        }
        th {
            background: #f2f2f2;
        }
        .page-break { 
            page-break-after: always; 
        }
        .header {
            width: 100%;
            margin-bottom: 10px;
        }
        .company-info {
            font-size: 11px;
            line-height: 1.4;
        }
    </style>
</head>
<body>

    {{-- Header --}}
    <table class="header" style="border:0px!important;">
        <tr>
            <td style="border:none!important;width:50%;text-align:center;">
                <img src="https://lcsinsight.com/assets/img/company-logo-second.png" 
                     style="width: 175px;">
            </td>
            <td style="border:none!important;width:50%;text-align:left;" class="company-info">
                <strong>Legacy Claims Services</strong><br/>
                5184 Caldwell Mill Road, Suite 204-230,<br/>
                Birmingham, Alabama 35244<br/>
                Email: claims@legacyclaimservices.com<br/>
                Phone: (800) 780-1699
            </td>
        </tr>
    </table>

    <h3>Invoice Report</h3>
    <div>Generated at: {{ $generated_at }}</div>
    <div>Total invoices: {{ $invoices->count() }}</div>
    <br/>

    {{-- Table --}}
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>File#</th>
                <th>Invoice #</th>
                <th>Owner Name</th>
                <th>Office</th>
                <th>Insurance</th>
                <th>Bulk Paying?</th>
                <th>Claim #</th>
                <th>Policy #</th>
                <th>Invoice Date</th>
                <th>Total</th>
                <th>Tax</th>
                <th>Amount Paid</th>
                <th>Balance</th>
            </tr>
        </thead>
        <tbody>
            @php	
                $invloop = 0; 
                $totalinvoiceAmount = 0;
                $totalTaxAmount = 0;
                $totalpaidAmount = 0;
            @endphp

            @foreach($invoices as $inv)
                @php
                    $taxAmount = (!empty($inv->finaltotal) && !empty($inv->taxpercentage))
                        ? ($inv->finaltotal * $inv->taxpercentage) / 100
                        : 0;

                    $balance = $inv->finaltotal + $taxAmount - $inv->amount_paid;
                    $ownerName = trim($inv->business_first_name . ' ' . $inv->business_last_name);

                    $totalinvoiceAmount += $inv->finaltotal;
                    $totalTaxAmount += $taxAmount;
                    $totalpaidAmount += $inv->amount_paid;

                    $invloop++;
                @endphp

                <tr>
                    <td>{{ $invloop }}</td>
                    <td>{{ $inv->file_no }}</td>
                    <td>{{ $inv->invoiceno }}</td>
                    <td>{{ $ownerName }}</td>
                    <td>{{ $inv->officename }}</td>
                    <td>{{ $inv->insurancecompanyname }}</td>
                    <td>{{ $inv->paying_type == 'single' ? 'NO' : 'YES' }}</td>
                    <td>{{ $inv->claim_number }}</td>
                    <td>{{ $inv->policy_number }}</td>
                    <td>{{ \Carbon\Carbon::parse($inv->gen_date)->format('m-d-Y') }}</td>
                    <td>${{ number_format($inv->finaltotal, 2) }}</td>
                    <td>${{ number_format($taxAmount, 2) }}</td>
                    <td>${{ number_format($inv->amount_paid, 2) }}</td>
                    <td>${{ number_format($balance, 2) }}</td>
                </tr>

                {{-- 🔹 Force page-break every 40 rows to avoid huge single-page tables --}}
                @if($loop->iteration % 40 == 0)
                    </tbody>
                </table>
                <div class="page-break"></div>
                <table>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>File#</th>
                            <th>Invoice #</th>
                            <th>Owner Name</th>
                            <th>Office</th>
                            <th>Insurance</th>
                            <th>Bulk Paying?</th>
                            <th>Claim #</th>
                            <th>Policy #</th>
                            <th>Invoice Date</th>
                            <th>Total</th>
                            <th>Tax</th>
                            <th>Amount Paid</th>
                            <th>Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                @endif

            @endforeach

            {{-- Totals --}}
            <tr>
                <td colspan="10" align="right"><strong>Total :</strong></td>
                <td><strong>${{ number_format($totalinvoiceAmount, 2) }}</strong></td>
                <td><strong>${{ number_format($totalTaxAmount, 2) }}</strong></td>
                <td><strong>${{ number_format($totalpaidAmount, 2) }}</strong></td>
                <td><strong>${{ number_format(($totalinvoiceAmount + $totalTaxAmount) - $totalpaidAmount, 2) }}</strong></td>
            </tr>
        </tbody>
    </table>

</body>
</html>
