<div class="p-6 space-y-6">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">📊 Average Invoice Report

                        <a href="{{ route('multi-report') }}" class="btn btn-success"
                            style="float: right;">Back to Multi Report</a>
                    </h4>
                </div>
            </div>

            <div class="card">
                <div class="card-body p-4">
                    <!-- Per Page Selector -->
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="perPage" class="form-label">Items per page:</label>
                            <select wire:model.live="perPage" id="perPage" class="form-select" style="width: auto;">
                                <option value="10">10</option>
                                <option value="25">25</option>
                                <option value="50">50</option>
                                <option value="100">100</option>
                            </select>
                        </div>
                        <div class="col-md-6 text-end">
                            <span class="text-muted">
                                Showing {{ (($currentPage - 1) * $perPage) + 1 }} to {{ min($currentPage * $perPage, $totalRecords) }} of {{ $totalRecords }} records
                            </span>

                            <div class="row">
                                <div class="col-md-6"></div>
                                <div class="col-md-6 mt-2">
                                    <div class="alert alert-info py-2 px-4 mb-0" bis_skin_checked="1">
                                        <strong>Average Invoice Amount: <span id="averageInvoiceAmount">{{ number_format($averageInvoiceAmount, 2) }}</span></strong>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive" style="overflow-x:scroll!important">
                        <!-- Table with stripped rows -->
                        <table id="tblAverageInvoiceReport" class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>S.No</th>
                                    <th>File No </th>
                                    <th>Invoice No </th>
                                    <th>Invoice Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($records as $index => $record)
                                    <tr>
                                        <td>{{ (($currentPage - 1) * $perPage) + $index + 1 }}</td>
                                        <td>{{ $record->file_no }}</td>
                                        <td>{{ $record->invoiceno }}</td>
                                        <td>{{ $record->invoice_amount }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination Controls -->
                    @if($totalPages > 1)
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <div>
                            <button wire:click="previousPage" 
                                    class="btn btn-outline-primary" 
                                    {{ $currentPage == 1 ? 'disabled' : '' }}>
                                ← Previous
                            </button>
                        </div>
                        
                        <div class="d-flex align-items-center">
                            @for($i = max(1, $currentPage - 2); $i <= min($totalPages, $currentPage + 2); $i++)
                                @if($i == $currentPage)
                                    <span class="btn btn-primary mx-1">{{ $i }}</span>
                                @else
                                    <button wire:click="goToPage({{ $i }})" class="btn btn-outline-primary mx-1">{{ $i }}</button>
                                @endif
                            @endfor
                        </div>
                        
                        <div>
                            <button wire:click="nextPage" 
                                    class="btn btn-outline-primary" 
                                    {{ $currentPage == $totalPages ? 'disabled' : '' }}>
                                Next →
                            </button>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>