<div>
<style>
    .checkbox {
        cursor: pointer;
    }
    .checkbox:checked {
        background-color: #007bff;
        border-color: #007bff;
    }
    .alert-info {
        background-color: #d1ecf1;
        border-color: #bee5eb;
        color: #0c5460;
        padding: 0.75rem 1.25rem;
        border-radius: 0.25rem;
    }
</style>

<div class="container-fluid">
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Receivable Report</h4>
            </div>
        </div>
    </div>


    <div class="col-md-12">
        <div class="card">
            <div class="card-body pt-3 ">
                <p></p>

                @if (session()->has('error'))
                    <div class="alert alert-danger">
                        {{ session('error') }}
                    </div>
                @endif


                <form wire:submit.prevent="search">
                    <div class="row">


                        <div class=" col-md-6 mb-2">
                            <label class="mb-2">By</label>
                            <label style="margin:0px;">
                                <input type="radio" wire:click="setTerm('term')" name="term" value="term" class="term" {{ $term === 'term' ? 'checked' : '' }}>
                                &nbsp;Term
                            </label>
                            &nbsp;&nbsp;&nbsp;&nbsp;
                            <label style="margin:0px;">
                                <input type="radio" wire:click="setTerm('custom')" name="term" value="custom" class="term" {{ $term === 'custom' ? 'checked' : '' }}>
                                &nbsp;Custom Date Range
                            </label>
                            &nbsp;&nbsp;&nbsp;&nbsp;
                            <label style="margin:0px;">
                                <input type="radio" wire:click="setTerm('specific')" name="term" value="specific" class="term" {{ $term === 'specific' ? 'checked' : '' }}>
                                &nbsp;Specific Date
                            </label>

                            
                            <div @if($this->showTermClass) style="display:block;" @else style="display:none;" @endif>
                                <select wire:model.defer="termname" class="form-control" name="termname" id="termname">
                                    <option value="all">All</option>
                                    <option value="30">0 - 30 Days</option>
                                    <option value="31">Over 31 Days</option>
                                    <option value="60">31 - 60 Days</option>
                                    <option value="61">Over 61 Days</option>
                                    <option value="90">61 - 90 Days</option>
                                    <option value="91">Over 90 Days</option>
                                    <option value="121">Over 120 Days</option>
                                </select>
                            </div>
                            

                            <div @if($this->showCustomDateRangeClass) style="display:block;" @else style="display:none;" @endif>
                                <div class="row">
                                    <div class="col-md-6">
                                        <input type="date" wire:model.defer="fromDate" class="form-control">

                                    </div>

                                    <div class="col-md-6">
                                        <input type="date" wire:model.defer="toDate" class="form-control">

                                    </div>

                                </div>

                            </div>

                            
                            <div @if($this->showSpecificDateClass) style="display:block;" @else style="display:none;" @endif>
                                <input type="date" wire:model.defer="specificDate" class="form-control">
                            </div>
                            

                        </div>

                        <div class="col-md-3 mb-2">
                            <label class="mb-2">Assignment Type</label>
                            <x-multiselect 
                                wire:key="unit-type-multiselect-{{ count($unit_types) }}"
                                wire:model.defer="unit_type"
                                :options="$unit_types"
                                option-value="id"
                                option-label="unit_type"
                                placeholder="Select Assignment Type"
                                search-placeholder="Search assignment type..."
                            />
                        </div>
                        <div class="col-md-3 mb-2">
                            <label class="mb-2">File Stage</label>
                            <x-multiselect 
                                wire:key="globalstatus-multiselect-{{ count($global_statuses) }}"
                                wire:model.defer="global_status"
                                :options="$global_statuses"
                                option-value="id"
                                option-label="status"
                                placeholder="Select File Stage"
                                search-placeholder="Search file stage..."
                            />
                        </div>

                    </div>
                    <div class="row">



                        <div class="col-md-3 mb-2">
                            <label class="mb-2">Insurance Company</label>
                            <x-multiselect 
                                wire:key="insurance-multiselect-{{ count($allInsurances) }}"
                                wire:model.defer="insurance"
                                :options="$allInsurances"
                                option-value="id"
                                option-label="company_name"
                                placeholder="Select Insurance Company"
                                search-placeholder="Search insurance company..."
                            />
                        </div>

                        <div class="col-md-3 mb-2">
                            <label class="mb-2">Adjuster</label>
                            <x-multiselect 
                                wire:key="adjuster-multiselect-{{ count($allAdjusters) }}"
                                wire:model.defer="adjuster"
                                :options="$allAdjusters"
                                option-value="id"
                                option-label-format="{name}"
                                placeholder="Select Adjuster"
                                search-placeholder="Search adjuster..."
                            />
                        </div>

                        <div class="col-md-3 mb-2">
                            <label class="mb-2">Offices </label>
                            <x-multiselect 
                                wire:key="franchise-multiselect-{{ count($allFranchises) }}"
                                wire:model.defer="franchise"
                                :options="$allFranchises"
                                option-value="id"
                                option-label-format="{franchisecode} - {company_name}"
                                placeholder="Select Offices"
                                search-placeholder="Search offices..."
                            />
                        </div>

                        <div class="col-md-3 mb-2">
                            <label class="mb-2">Status</label>
                            <select wire:model.defer="status" class="form-control">
                                <option value="">All</option>
                                <option value="paid">Paid</option>
                                <option value="unpaid">Unpaid</option>
                            </select>
                        </div>



                    </div>
                    <div class="row mb-3">

                        <div class="col-md-6 mb-2">
                            <label class="mb-2">Search by invoice #</label>
                            <textarea wire:model.defer="searchbyinvoiceno" class="form-control" rows="3"></textarea>
                            <em>The numbers should be separated by commas and without spaces. For example
                                1234,2022-64358-A,5686461</em>
                        </div>

                        <div class="col-md-6 mb-2">
                            <label class="mb-2">Search by file #, claim #, policy #</label>
                            <textarea wire:model.defer="searchbyfileno" class="form-control" rows="3"></textarea>

                        </div>

                        <div class="col-md-12 mb-2">
                            <label class="mb-2">Number of Records Per Page:</label>
                            <select wire:model.defer="perPage" class="form-control">
                                <option value="25">25</option>
                                <option value="50">50</option>
                                <option value="100">100</option>
                                <option value="all">Show All</option>
                            </select>
                        </div>




                        <div class="col-md-12  mb-3" style="text-align: center;">

                            <button type="submit" class="btn btn-primary">Run Report</button>

                        </div>


                </form>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <button type="button" class="btn btn-warning" wire:click="testLivewire">
                            Test Livewire Connection
                        </button>
                        @if (session()->has('message'))
                            <span class="badge bg-success">{{ session('message') }}</span>
                        @endif
                    </div>
                    <div class="col-md-6 text-end">
                        <button type="button" class="btn btn-success" wire:click="openBulkPaymentModal" 
                                {{ count($invoices_selected) == 0 ? 'disabled' : '' }}>
                            <i class="bi bi-cash-coin"></i> Bulk Payment
                        </button>
                        <button type="button" class="btn btn-info" wire:click="exportToCSV">
                            <i class="bi bi-file-earmark-excel"></i> Export to CSV
                        </button>

                        <button type="button" class="btn btn-primary" wire:click="exportFilteredInvoicesPdf">
                            <i class="bi bi-download"></i> Export Invoices to PDF
                        </button>                       


                    </div>
                </div>
                
                <div class="relative">
                    <!-- 🔄 Loader Overlay -->
                    <div wire:loading class="absolute inset-0 z-10 bg-white/70 flex items-center justify-center">
                        <div class="loader"></div>

                    </div>

                    <div class="table-responsive">
                        <table class="table table-striped datatable dataTable">
                            <thead class="thead-dark">
                                <tr>
                                    <th>
                                        <input type="checkbox" 
                                                wire:model.live="selectAll" 
                                                class="checkbox checkbox-lg">
                                    </th>
                                    <th>File#</th>
                                    <th>Invoice #</th>
                                    <th>Owner Name </th>
                                    <th>Office</th>
                                    <th>Insurance</th>
                                    <th>Bulk Paying?</th>
                                    <th>Claim # </th>
                                    <th>Policy # </th>
                                    <th>Invoice Date</th>
                                    <th>Total</th>
                                    <th>Tax</th>
                                    <th>Amount Paid </th>
                                    <th>Balance</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php $totaltaxamount = 0; @endphp

                                @foreach($records as $record)

                                    @php
                                        $taxAmount = (!empty($record->finaltotal) && !empty($record->taxpercentage))
                                            ? ($record->finaltotal * $record->taxpercentage) / 100
                                            : 0;
                                        $totaltaxamount += $taxAmount;
                                        $invoiceRowAmount = $record->finaltotal + $taxAmount;
                                    @endphp

                                    <tr>
                                        <td><input type="checkbox" 
                                                wire:click="toggleInvoiceSelection({{$record->invoiceID}})" 
                                                {{ in_array($record->invoiceID, $invoices_selected) ? 'checked' : '' }}
                                                class="checkbox checkbox-lg"></td>
                                        <td>{{ $record->file_no }}</td>
                                        <td>{{ $record->invoiceno }}</td>
                                        <td>{{ $record->business_first_name }} {{ $record->business_last_name }}</td>
                                        <td>{{ $record->officename }}</td>
                                        <td>{{ $record->insurancecompanyname }}</td>
                                        <td><span
                                                class="badge {{ $record->paying_type == 'single' ? 'bg-danger' : 'bg-success' }}">
                                                {{ $record->paying_type == 'single' ? 'NO' : 'YES' }} </span>
                                        </td>
                                        <td>{{ $record->claim_number }}</td>
                                        <td>{{ $record->policy_number }}</td>
                                        <td>{{ \Carbon\Carbon::parse($record->gen_date)->format('m-d-Y') }}</td>
                                        <td>${{ number_format($record->finaltotal, 2) }}</td>
                                        <td>${{ number_format($taxAmount, 2) }}</td>
                                        <td>${{ number_format($record->amount_paid, 2) }}</td>
                                        <td>${{ number_format($invoiceRowAmount - $record->amount_paid, 2) }}</td>

                                    </tr>

                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="10" align="right">Total :</td>
                                    <td><strong>${{ number_format($totalinvoiceAmount, 2) }}</strong></td>
                                    <td><strong>${{ number_format($totalTaxAmount, 2) }}</strong></td>
                                    <td><strong>${{ number_format($totalpaidAmount, 2) }}</strong></td>
                                    <td><strong>${{ number_format(($totalinvoiceAmount + $totalTaxAmount) - $totalpaidAmount, 2) }}</strong>
                                    </td>
                                </tr>
                            </tfoot>

                        </table>
                    </div>

                    <h1 style="float: right; font-weight: bold;">Total Invoices (inc Tax):
                        ${{number_format(($totalinvoiceAmount + $totalTaxAmount), 2)}}</h1>
                    <br /><br />
                    @if ($records instanceof \Illuminate\Pagination\LengthAwarePaginator || $records instanceof \Illuminate\Pagination\Paginator)
                        {{ $records->links() }}
                    @endif

                </div>

            </div>
        </div>
    </div>

</div>
</div>

<!-- Bulk Payment Modal -->
<div>
    @if ($showBulkPaymentModal)
        <div class="modal d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5); z-index: 1050;">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Collect Payment</h5>
                        <button type="button" class="btn-close" wire:click="closeBulkPaymentModal"></button>
                    </div>
                    <div class="modal-body">
                        
                        <div class="row mb-3">
                            <div class="col-md-12">
                                <h5>{{ count($invoices_selected) }} Invoices selected</h5>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <label for="bulk_date_received">Date Received</label>
                                <input type="date" wire:model="bulk_date_received" class="form-control">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <label for="bulk_pay_amount">Total Amount</label>
                                <input type="number" wire:model="bulk_payment_amount" class="form-control">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <label for="bulk_invoice_amount">Notes</label>
                                <textarea wire:model="bulk_payment_note" class="form-control" rows="3"></textarea>
                            </div>
                        </div>


                    </div>
                    <div class="modal-footer">
                        <button wire:click="closeBulkPaymentModal" class="btn btn-secondary">Close</button>
                        <button wire:click="processBulkPayment" class="btn btn-primary">Process Bulk Payment</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show" style="z-index: 1040;"></div>
    @endif
</div>

</div>