<div class="p-6 space-y-6">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">📊 Multi Report Dashboard</h4>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <div class="card">
                <div class="card-body pt-3 ">
                    <p></p>

                    @if (session()->has('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    <!-- Report Filter Form -->
                    <form wire:submit.prevent="goToReport">
                        <div class="row">
                            <div class=" col-md-3 mb-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Select Report</label>
                                <select wire:model="selectedReport" class="form-control">
                                    <option value="report-stage-lifecycle">Stage Lifecycle</option>
                                    <option value="report-assignment-perday">Assignment Per Day</option>
                                    <option value="report-assignment-cycletime">Assignment Cycle Time</option>
                                    <option value="report-average-cycletime">Average Cycle Time</option>
                                    <option value="report-average-invoicereport">Average Invoice Report</option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class=" col-md-6">
                                <div class="row">

                                    <div class=" col-md-6 mb-2">
                                        <label class="block text-sm font-medium text-gray-700 mb-2">From Date</label>
                                        <input type="date" wire:model="from_date" class="form-control" />
                                    </div>

                                    <div class=" col-md-6 mb-2">
                                        <label class="block text-sm font-medium text-gray-700 mb-2">To Date</label>
                                        <input type="date" wire:model="to_date" class="form-control" />
                                    </div>
                                </div>
                            </div>

                            <div class=" col-md-3 mb-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Offices</label>
                                <x-multiselect 
                                    wire:model.defer="franchise_id"
                                    :options="$franchises"
                                    option-value="id"
                                    option-label="franchisecode"
                                    option-sublabel="company_name"
                                    placeholder="Select Offices"
                                    search-placeholder="Search offices..."
                                />
                            </div>
                            <div class=" col-md-3 mb-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Assignment Type</label>
                                <x-multiselect 
                                    wire:model.defer="unit_type"
                                    :options="$unit_types"
                                    option-value="id"
                                    option-label="unit_type"
                                    placeholder="Select Assignment Type"
                                    search-placeholder="Search assignment type..."
                                />
                            </div>

                            <div class=" col-md-3 mb-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Insurance Company</label>
                                <x-multiselect 
                                    wire:model.defer="insurance_company_id"
                                    :options="$insuranceCompanies"
                                    option-value="id"
                                    option-label="company_name"
                                    placeholder="Select Insurance Companies"
                                    search-placeholder="Search insurance companies..."
                                />
                            </div>

                            <div class=" col-md-3 mb-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Insurance Adjuster </label>
                                <x-multiselect 
                                    wire:model.defer="adjuster_id"
                                    :options="$adjusters"
                                    option-value="id"
                                    option-label-format="{name} ({company_name})"
                                    placeholder="Select Adjuster"
                                    search-placeholder="Search adjuster..."
                                />
                            </div>

                            <div class=" col-md-3 mb-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Insurance Appraiser </label>
                                <x-multiselect 
                                    wire:model.defer="appraiser_id"
                                    :options="$appraisers"
                                    option-value="id"
                                    option-label-format="{name}"
                                    placeholder="Select Appraiser"
                                    search-placeholder="Search appraiser..."
                                />
                            </div>
                            
                            <div class=" col-md-3 mb-2">
                                <label class="block text-sm font-medium text-gray-700 mb-2">File Stage</label>
                                <x-multiselect 
                                    wire:model.defer="global_status"
                                    :options="$global_statuses"
                                    option-value="id"
                                    option-label="status"
                                    placeholder="Select File Stage"
                                    search-placeholder="Search file stage..."
                                />
                            </div>



                            <div class="col-span-full mt-4">
                                <button type="submit"
                                    class="bg-blue-600 btn btn-primary px-4 py-2 rounded hover:bg-blue-700">🔍 View
                                    Report</button>
                            </div>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>
</div>