<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">File Aged Report</h4>
                </div>
                <div class="card-body">
                    <form  wire:submit.prevent="search" class="row">

                        <div class="col-md-3 pt-2">
                            <label>Days</label>
                            <select name="days" class="form-control" id="days" wire:model="days">
                            @for ($i = 1; $i <= 31; $i++)
                                <option value="{{ $i }}">{{ $i }}</option>
                            @endfor
                            </select>
                        </div>

                        <div class="col-md-3 pt-2">
                            <label>Insurance Company</label>
                            <x-multiselect 
                                    wire:key="insurance-multiselect-{{ count($allInsurances) }}"
                                    wire:model.defer="insurance"
                                    :options="$allInsurances"
                                    option-value="id"
                                    option-label="company_name"
                                    placeholder="Select Insurance Company"
                                    search-placeholder="Search insurance company..."
                                />
                        </div>

                        <div class="col-md-3 pt-2">
                            <label class="mb-2">Insurance Appraiser </label>
                                <x-multiselect 
                                    wire:key="appraiser-multiselect-{{ count($allAppraisers) }}"
                                    wire:model.defer="appraiser"
                                    :options="$allAppraisers"
                                    option-value="id"
                                    option-label-format="{name}"
                                    placeholder="Select Appraiser"
                                    search-placeholder="Search appraiser..."
                                />
                        </div>

                        <div class="col-md-3 pt-2">
                            <label class="mb-2">Insurance Adjuster </label>
                                <x-multiselect 
                                    wire:key="adjuster-multiselect-{{ count($allAdjusters) }}"
                                    wire:model.defer="adjuster"
                                    :options="$allAdjusters"
                                    option-value="id"
                                    option-label-format="{name} ({company_name})"
                                    placeholder="Select Adjuster"
                                    search-placeholder="Search adjuster..."
                                />
                        </div>
                        <div class="col-md-3 pt-2">
                            <label class="mb-2">Offices </label>
                                <x-multiselect 
                                    wire:key="franchise-multiselect-{{ count($allFranchises) }}"
                                    wire:model.defer="franchise"
                                    :options="$allFranchises"
                                    option-value="id"
                                    option-label-format="{franchisecode} - {company_name}"
                                    placeholder="Select Offices"
                                    search-placeholder="Search offices..."
                                />
                        </div>

                        <div class="col-md-3 pt-2">
                            <label class="mb-2">Assignment Type </label>
                            <x-multiselect 
                                wire:key="unit-type-multiselect-{{ count($unit_types) }}"
                                wire:model.defer="unit_type"
                                :options="$unit_types"
                                option-value="id"
                                option-label="unit_type"
                            />
                        </div>

                        <div class="col-md-3 pt-2">
                            <label class="mb-2">File Stage </label>
                            <x-multiselect 
                                wire:key="global-status-multiselect-{{ count($global_statuses) }}"
                                wire:model.defer="global_status"
                                :options="$global_statuses"
                                option-value="id"
                                option-label="status"
                            />
                        </div>

                        <div class="col-md-6 pt-2"></div>

                        <div class="col-md-3 pt-3" style="text-align:left;">
                            <button type="submit" class="btn btn-primary">Run Report</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
          
        <div class="col-12">
            <div class="row">
              <div class="col-md-12">
                    <div class="card">
                        <div class="card-body pt-2">
                            <table class='table table-striped datatable dataTable'>
                                <thead>
                                    <tr>
                                        <th>S.No</th>
			                            <th>File</th>
			                            <th>Office</th>
			                            <th>Insurance</th>
			                            <th>Adjuster</th>
			                            <th>Appraiser</th>
			                            <th>Date Open</th>
			                            <th>Status</th>
			                            <th>Phase</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @forelse($report_data as $index => $data)
                                	<tr>
                                         <td>{{ $report_data->firstItem() + $index }}</td>
                                        <td>{{ $data->file_no }}</td>
			                            <td>{{ $data->franchise->company_name ?? '' }}</td>
			                            <td>{{ $data->insurancecompany->company_name ?? '' }}</td>
			                            <td>{{ $data->adjuster->name ?? '' }} </td>
			                            <td>{{ $data->appraiser->name ?? '' }}</td>
			                            <td>{{ date('d-m-Y H:i:s A' ,strtotime($data->created_date)) }}</td>
			                            <td>{{ $data->status->status ?? '' }}</td>
			                            <td>{{ $data->phase->phase ?? '' }}</td>
			                        </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" style="text-align:center;">No data found.</td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>
                            {{ $report_data->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>