<div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Client KPI</h4>
                </div>
            </div>
        </div>


        <div class="col-md-12">
            <div class="card">
                <div class="card-body pt-3 ">
                    <p></p>

                    @if (session()->has('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif


                    <form wire:submit.prevent="search">
                        <div class="row mb-3">


                            <div class=" col-md-6 mb-2">
                                <label class="mb-2">Date Range</label>                                                 
                                  <div class="row">
                                        <div class="col-md-6">
                                            <input type="date" wire:model="from_date" class="form-control">

                                        </div>

                                        <div class="col-md-6">
                                            <input type="date" wire:model="to_date" class="form-control">

                                        </div>
                                    </div>

                            </div>
                            <div class="col-md-3 mb-2" >
                                <label class="mb-2">Offices </label>
                                <x-multiselect 
                                    wire:key="franchise-multiselect-{{ count($allFranchises) }}"
                                    wire:model.defer="franchise"
                                    :options="$allFranchises"
                                    option-value="id"
                                    option-label-format="{franchisecode} - {company_name}"
                                    placeholder="Select Offices"
                                    search-placeholder="Search offices..."
                                />
                            </div>

                            <div class="col-md-3 mb-2" >
                                <label class="mb-2">Assignment Type </label>
                                <x-multiselect 
                                    wire:key="unit-type-multiselect-{{ count($unit_types) }}"
                                    wire:model.defer="unit_type"
                                    :options="$unit_types"
                                    option-value="id"
                                    option-label="unit_type"
                                    placeholder="Select Assignment Type"
                                    search-placeholder="Search assignment type..."
                                />
                            </div>


                        </div>

                        <div class="row mb-3">
                            <div class="col-md-3 mb-2" >
                                <label class="mb-2">Insurance Company</label>
                                <x-multiselect 
                                    wire:key="insurance-multiselect-{{ count($allInsurances) }}"
                                    wire:model.defer="insurance"
                                    :options="$allInsurances"
                                    option-value="id"
                                    option-label="company_name"
                                    placeholder="Select Insurance Company"
                                    search-placeholder="Search insurance company..."
                                />
                            </div>
                            <div class="col-md-3 mb-2" >
                                <label class="mb-2">Insurance Adjuster </label>
                                <x-multiselect 
                                    wire:key="adjuster-multiselect-{{ count($allAdjusters) }}"
                                    wire:model.defer="adjuster"
                                    :options="$allAdjusters"
                                    option-value="id"
                                    option-label-format="{name} ({company_name})"
                                    placeholder="Select Adjuster"
                                    search-placeholder="Search adjuster..."
                                />
                            </div>
                            <div class="col-md-3 mb-2" >
                                <label class="mb-2">Insurance Appraiser </label>
                                <x-multiselect 
                                    wire:key="appraiser-multiselect-{{ count($allAppraisers) }}"
                                    wire:model.defer="appraiser"
                                    :options="$allAppraisers"
                                    option-value="id"
                                    option-label-format="{name}"
                                    placeholder="Select Appraiser"
                                    search-placeholder="Search appraiser..."
                                />
                            </div>
                            <div class="col-md-3 mb-2" >
                                <label class="mb-2">File Stage </label>
                                <x-multiselect 
                                    wire:key="globalstatus-multiselect-{{ count($global_statuses) }}"
                                    wire:model.defer="global_status"
                                    :options="$global_statuses"
                                    option-value="id"
                                    option-label="status"
                                    placeholder="Select File Stage"
                                    search-placeholder="Search file stage..."
                                />
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-3 mb-2">
                                <div class="form-check">
                                    <input type="checkbox" wire:model="exclude_weekends" class="form-check-input" id="exclude_weekends">
                                    <label class="form-check-label" for="exclude_weekends">
                                        Exclude Weekends
                                    </label>
                                </div>
                            </div>
                        </div>

                
                        <div class="row mb-3">

                            <div class="col-md-12  mb-3" style="text-align: center;">

                                <button type="submit" class="btn btn-primary">Run Report</button>
                                <button wire:click="exportCsv" class="btn btn-success ">Download CSV</button>


                            </div>


                    </form>

                 
                    <div class="relative">
                        <!-- 🔄 Loader Overlay -->
                        <div wire:loading class="absolute inset-0 z-10 bg-white/70 flex items-center justify-center">
                            <div class="loader"></div>

                        </div>

                        <div class="table-responsive">
                            <table class="table table-striped datatable dataTable">
                                <thead class="thead-dark">
                                    <tr>
                                        <th>S.No</th>
                                        <th>Insurance</th>
                                        <th>Assignment Count</th>
                                        <th>Avg Days</th>
                                        <th>Supp Ratio %</th>
                                        <th>Supp Assignment Count</th>
                                        <th>Supp Avg Days</th>
                                    </tr>
                                </thead>
                                <tbody>
                                            @forelse  ($stats as $index => $row)
                                            <tr>
                                            <td>{{ $stats->firstItem() + $index }}</td>
                                            <td>{{ $row->company_name }}</td>
                                            <td>{{ $row->assignment_count }}</td>
                                            <td class="{{ $row->avg_days > 10 ? 'text-danger fw-bold' : 'text-success fw-bold' }}">
                                            {{ $row->avg_days }}
                                            </td>

                                            <td>{{ $row->supp_ratio }}%</td>
                                            <td>{{ $row->supp_count }}</td>

                                            <td class="{{ $row->supp_avg_days > 10 ? 'text-danger fw-bold' : 'text-success fw-bold' }}">
                                            {{ $row->supp_avg_days }}
                                            </td>

                                            </tr>
                                            @empty
                                            <tr>
                                            <td colspan="7" class="text-center text-muted">No record found</td>
                                            </tr>

                                            @endforelse 
                                </tbody>
                                

                            </table>
                        </div>

                       
                        {{ $stats->links() }}

                    </div>

                </div>
            </div>
        </div>




    </div>

</div>