<div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h4 class="card-title mb-1">Client Health Report</h4>
                            <p class="card-subtitle mb-0">Insurance Company Assignment Volume Trends</p>
                        </div>
                        <div class="col-md-4 text-end">
                            <small class="text-muted">
                                Generated: {{ now()->format('M d, Y \a\t g:i A') }}
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <div class="card">
                <div class="card-body pt-3">
                    <!-- Year Selector -->
                    <div class="row mb-4">
                        <div class="col-md-2">
                            <label for="year" class="form-label">Select Year:</label>
                            <select wire:model.live="selectedYear" class="form-select" id="year">
                                @for($year = date('Y'); $year >= date('Y') - 5; $year--)
                                    <option value="{{ $year }}">{{ $year }}</option>
                                @endfor
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label for="search" class="form-label">Search Company:</label>
                            <input wire:model.live.debounce.300ms="searchTerm" type="text" class="form-control" id="search" placeholder="Search insurance companies...">
                        </div>
                        <div class="col-md-2">
                            <label for="trend" class="form-label">Filter by Trend:</label>
                            <select wire:model.live="filterTrend" class="form-select" id="trend">
                                <option value="">All Trends</option>
                                <option value="increasing">Increasing</option>
                                <option value="decreasing">Decreasing</option>
                                <option value="stable">Stable</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label for="perPage" class="form-label">Per Page:</label>
                            <select wire:model.live="perPage" class="form-select" id="perPage">
                                <option value="10">10</option>
                                <option value="25">25</option>
                                <option value="50">50</option>
                                <option value="100">100</option>
                            </select>
                        </div>
                        <div class="col-md-2 d-flex align-items-end">
                            <button wire:click="exportToCsv" class="btn btn-success">
                                <i class="fas fa-download"></i> Export to CSV
                            </button>
                        </div>
                    </div>

                    @if (session()->has('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    @if ($errorMessage)
                        <div class="alert alert-danger">
                            {{ $errorMessage }}
                        </div>
                    @endif

                    <!-- Results Summary -->
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="alert alert-info">
                                <strong>Showing {{ count($this->filteredCompanies) }} of {{ count($insuranceCompanies) }} insurance companies</strong>
                                @if($searchTerm)
                                    <br>Filtered by: "{{ $searchTerm }}"
                                @endif
                                @if($filterTrend)
                                    <br>Trend filter: {{ ucfirst($filterTrend) }}
                                @endif
                                @if($this->totalPages > 1)
                                    <br>Page {{ $this->currentPage }} of {{ $this->totalPages }} 
                                    ({{ $this->perPage }} per page)
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Insurance Companies Table -->
                    <div class="table-responsive">
                        @if($isLoading)
                            <div class="text-center py-4">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                                <p class="mt-2 text-muted">Loading data...</p>
                            </div>
                        @else
                        <table class="table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>
                                        <a href="#" wire:click.prevent="sortByField('company_name')" class="text-white text-decoration-none">
                                            Insurance Company
                                            @if($sortBy === 'company_name')
                                                <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                            @else
                                                <i class="fas fa-sort text-muted"></i>
                                            @endif
                                        </a>
                                    </th>
                                    <th>
                                        <a href="#" wire:click.prevent="sortByField('total_assignments')" class="text-white text-decoration-none">
                                            Total Assignments
                                            @if($sortBy === 'total_assignments')
                                                <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }}"></i>
                                            @else
                                                <i class="fas fa-sort text-muted"></i>
                                            @endif
                                        </a>
                                    </th>
                                    <th>Trend</th>
                                    <th>Change %</th>
                                    <th>Monthly Breakdown</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($this->paginatedCompanies as $company)
                                    @php
                                        $tData = $trendData[$company->id] ?? [];
                                        $mData = $monthlyData[$company->id] ?? [];
                                    @endphp
                                    <tr>
                                        <td>
                                            <strong>{{ $company->company_name ?? 'Unknown Company' }}</strong>
                                        </td>
                                        <td>
                                            <span class="badge bg-primary fs-6">
                                                {{ $tData['total_assignments'] ?? 0 }}
                                            </span>
                                        </td>
                                        <td>
                                            @if(isset($tData['trend']))
                                                @if($tData['trend'] === 'increasing')
                                                    <span class="badge bg-success">
                                                        <i class="fas fa-arrow-up"></i> Increasing
                                                    </span>
                                                @elseif($tData['trend'] === 'decreasing')
                                                    <span class="badge bg-danger">
                                                        <i class="fas fa-arrow-down"></i> Decreasing
                                                    </span>
                                                @else
                                                    <span class="badge bg-secondary">
                                                        <i class="fas fa-minus"></i> Stable
                                                    </span>
                                                @endif
                                                <br>
                                                {{-- <small class="text-muted">
                                                    Month: {{ $tData['current_month_progress'] ?? 0 }}% complete
                                                    ({{ $tData['days_passed'] ?? 0 }}/{{ $tData['days_in_month'] ?? 30 }} days)
                                                </small> --}}
                                            @else
                                                <span class="text-muted">N/A</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if(isset($tData['percentage']))
                                                @if($tData['percentage'] > 0)
                                                    <span class="text-success fw-bold">+{{ $tData['percentage'] }}%</span>
                                                @elseif($tData['percentage'] < 0)
                                                    <span class="text-danger fw-bold">{{ $tData['percentage'] }}%</span>
                                                @else
                                                    <span class="text-muted">{{ $tData['percentage'] }}%</span>
                                                @endif
                                                <br>
                                                <small class="text-muted">
                                                    Compared to same date last month.
                                                </small>
                                            @else
                                                <span class="text-muted">N/A</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="d-flex flex-wrap gap-1">
                                                @for($month = 1; $month <= 12; $month++)
                                                    @php
                                                        $count = $mData[$month] ?? 0;
                                                        $monthName = date('M', mktime(0, 0, 0, $month, 1));
                                                    @endphp
                                                    <div class="text-center" style="min-width: 40px;">
                                                        <div class="small text-muted">{{ $monthName }}</div>
                                                        <div class="badge bg-light text-dark border">
                                                            {{ $count }}
                                                        </div>
                                                    </div>
                                                @endfor
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center text-muted">
                                            No insurance companies found.
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                        @endif
                    </div>

                    <!-- Pagination Controls -->
                    @if($this->totalPages > 1)
                        <div class="row mt-4">
                            <div class="col-md-6">
                                <div class="d-flex align-items-center">
                                    <span class="text-muted me-3">
                                        Showing {{ (($this->currentPage - 1) * $this->perPage) + 1 }} to 
                                        {{ min($this->currentPage * $this->perPage, $this->filteredCompanies->count()) }} 
                                        of {{ $this->filteredCompanies->count() }} results
                                    </span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <nav aria-label="Pagination">
                                    <ul class="pagination justify-content-end mb-0">
                                        <!-- Previous Page -->
                                        <li class="page-item {{ $this->currentPage == 1 ? 'disabled' : '' }}">
                                            <a class="page-link" href="#" wire:click.prevent="previousPage">
                                                <i class="fas fa-chevron-left"></i> Previous
                                            </a>
                                        </li>
                                        
                                        <!-- Page Numbers -->
                                        @php
                                            $start = max(1, $this->currentPage - 2);
                                            $end = min($this->totalPages, $this->currentPage + 2);
                                        @endphp
                                        
                                        @if($start > 1)
                                            <li class="page-item">
                                                <a class="page-link" href="#" wire:click.prevent="goToPage(1)">1</a>
                                            </li>
                                            @if($start > 2)
                                                <li class="page-item disabled">
                                                    <span class="page-link">...</span>
                                                </li>
                                            @endif
                                        @endif
                                        
                                        @for($page = $start; $page <= $end; $page++)
                                            <li class="page-item {{ $page == $this->currentPage ? 'active' : '' }}">
                                                <a class="page-link" href="#" wire:click.prevent="goToPage({{ $page }})">{{ $page }}</a>
                                            </li>
                                        @endfor
                                        
                                        @if($end < $this->totalPages)
                                            @if($end < $this->totalPages - 1)
                                                <li class="page-item disabled">
                                                    <span class="page-link">...</span>
                                                </li>
                                            @endif
                                            <li class="page-item">
                                                <a class="page-link" href="#" wire:click.prevent="goToPage({{ $this->totalPages }})">{{ $this->totalPages }}</a>
                                            </li>
                                        @endif
                                        
                                        <!-- Next Page -->
                                        <li class="page-item {{ $this->currentPage == $this->totalPages ? 'disabled' : '' }}">
                                            <a class="page-link" href="#" wire:click.prevent="nextPage">
                                                Next <i class="fas fa-chevron-right"></i>
                                            </a>
                                        </li>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                        
                        <!-- Quick Page Jump -->
                        <div class="row mt-2">
                            <div class="col-md-12 text-center">
                                <div class="d-flex align-items-center justify-content-center">
                                    <span class="text-muted me-2">Go to page:</span>
                                    <input type="number" 
                                           wire:model.live="currentPage" 
                                           min="1" 
                                           max="{{ $this->totalPages }}" 
                                           class="form-control" 
                                           style="width: 80px;"
                                           placeholder="Page">
                                    <span class="text-muted ms-2">of {{ $this->totalPages }}</span>
                                </div>
                            </div>
                        </div>
                    @endif

                    <!-- Summary Statistics -->
                    @if(count($this->filteredCompanies) > 0)
                        <div class="row mt-4">
                            <div class="col-md-4">
                                <div class="card bg-success text-white pt-3">
                                    <div class="card-body text-center">
                                        <h5 class="card-title">Growing Companies</h5>
                                        <h3 class="mb-0">
                                            {{ collect($trendData)->where('trend', 'increasing')->count() }}
                                        </h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card bg-danger text-white pt-3">
                                    <div class="card-body text-center">
                                        <h5 class="card-title">Declining Companies</h5>
                                        <h3 class="mb-0">
                                            {{ collect($trendData)->where('trend', 'decreasing')->count() }}
                                        </h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="card bg-secondary text-white pt-3">
                                    <div class="card-body text-center">
                                        <h5 class="card-title">Stable Companies</h5>
                                        <h3 class="mb-0">
                                            {{ collect($trendData)->where('trend', 'stable')->count() }}
                                        </h3>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
    <style>
        .pagination .page-link {
            color: #0d6efd;
            border-color: #dee2e6;
        }
        
        .pagination .page-item.active .page-link {
            background-color: #0d6efd;
            border-color: #0d6efd;
            color: white;
        }
        
        .pagination .page-item.disabled .page-link {
            color: #6c757d;
            pointer-events: none;
            background-color: #fff;
            border-color: #dee2e6;
        }
        
        .table th a {
            transition: color 0.2s ease;
        }
        
        .table th a:hover {
            color: #fff !important;
        }
        
        .table th a .fa-sort {
            opacity: 0.5;
        }
        
        .table th a:hover .fa-sort {
            opacity: 1;
        }
        
        .per-page-selector {
            min-width: 80px;
        }
    </style>
    <script>
        document.addEventListener('livewire:load', function () {
            // Keyboard navigation for pagination
            document.addEventListener('keydown', function(e) {
                if (e.target.tagName === 'INPUT' || e.target.tagName === 'TEXTAREA') {
                    return; // Don't interfere with form inputs
                }
                
                if (e.key === 'ArrowLeft' || e.key === 'ArrowUp') {
                    e.preventDefault();
                    @this.call('previousPage');
                } else if (e.key === 'ArrowRight' || e.key === 'ArrowDown') {
                    e.preventDefault();
                    @this.call('nextPage');
                }
            });
        });
    </script>
@endpush