<div class="container-fluid">
    <div class="row">
          
        <div class="col-12">
            <div class="row">
              <div class="col-md-12">
                    <div class="card">
                        <div class="card-header mb-3">
                            <h4 class="card-title">Appraiser Report</h4>
                        </div>
                          
                        <div class="card-body pt-2">

                            
                            <div class="row mb-3">
                                <div class="col-md-3">
                                    <label for="exclude_supplement">From Date</label><br>
                                    <input type="date" wire:model.live="from_date" id="from_date" class="form-control">
                                </div>
                                <div class="col-md-3">
                                    <label for="exclude_supplement">To Date</label><br>
                                    <input type="date" wire:model.live="to_date" id="to_date" class="form-control">
                                </div>
                                <div class="col-md-3">
                                    <label for="exclude_supplement">Assignment Type </label><br>
                                    <x-multiselect 
                                        wire:key="unit-type-multiselect-{{ count($unit_types) }}"
                                        wire:model.live="unit_type"
                                        :options="$unit_types"
                                        option-value="id"
                                        option-label="unit_type"
                                    />
                                </div>
                                <div class="col-md-3">
                                    <label for="exclude_supplement">Exclude Supplement</label><br>
                                    <input type="checkbox" wire:model.live="exclude_supplement" id="exclude_supplement" class="form-check-input">
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-3">
                                    <label for="franchise">Insurance Company</label><br>
                                    <x-multiselect 
                                        wire:key="insurance-multiselect-{{ count($insurance_companies) }}"
                                        wire:model.live="insurance_company"
                                        :options="$insurance_companies"
                                        option-value="id"
                                        option-label="company_name"
                                        placeholder="Select Insurance Company"
                                        search-placeholder="Search insurance company..."
                                    />
                                </div>
                                <div class="col-md-3">
                                    <label for="franchise">Franchise</label><br>
                                    <x-multiselect 
                                        wire:key="franchise-multiselect-{{ count($franchises) }}"
                                        wire:model.live="franchise"
                                        :options="$franchises"
                                        option-value="id"
                                        option-label-format="{franchisecode} - {company_name}"
                                        placeholder="Select Franchise"
                                        search-placeholder="Search franchise..."
                                    />
                                </div>
                                <div class="col-md-3">
                                    <label for="exclude_supplement">File Stage </label><br>
                                    <x-multiselect 
                                        wire:key="global-status-multiselect-{{ count($global_statuses) }}"
                                        wire:model.live="global_status"
                                        :options="$global_statuses"
                                        option-value="id"
                                        option-label="status"
                                    />
                                </div>
                                <div class="col-md-3">
                                    <label for="exclude_supplement">Exclude Weekends</label><br>
                                    <input type="checkbox" wire:model.live="exclude_weekend" id="exclude_weekend" class="form-check-input">
                                </div>
                                
                            </div>
                            
                            <!-- Loading Spinner -->
                            @if($isLoading)
                            <div class="row mb-3">
                                <div class="col-12 text-center">
                                    <div class="d-flex align-items-center justify-content-center">
                                        <div class="spinner-border text-primary me-2" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                        <span class="text-muted">Loading data...</span>
                                    </div>
                                </div>
                            </div>
                            @endif

                            <table class='table table-striped datatable dataTable'>
                                <thead>
                                    <tr>
                                        <th>S.No</th>
				                        <th>Appraiser</th>
				                        <th>Total Assignment Count</th>
				                        <th>Total Open Count</th>
				                        <th>Total Complete Count</th>
				                        <th>Cycle Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @forelse($appraiser_data as $index => $data)
                                	<tr>
                                         <td>{{ $appraiser_data->firstItem() + $index }}</td>
                                        <td>{{ $data->name }}</td>
				                        <td>{{ $data->total_open+$data->total_completes }}</td>
				                        <td>{{ $data->total_open }}</td>
				                        <td>{{ $data->total_completes }}</td>
				                        <td>{{ $this->formatCycleTime($data->avg_completion_hours) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" style="text-align:center;">No data found.</td>
                                    </tr>
                                @endforelse
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th class="table-warning bg-warning text-black">TOTALS:</th>
                                        <th class="table-warning bg-warning text-black"></th>
                                        <th class="table-warning bg-warning text-black">{{ number_format($totals['total_assignments']) }}</th>
                                        <th class="table-warning bg-warning text-black">{{ number_format($totals['total_open']) }}</th>
                                        <th class="table-warning bg-warning text-black">{{ number_format($totals['total_completes']) }}</th>
                                        <th class="table-warning bg-warning text-black">{{ $this->formatCycleTime($totals['total_cycle_time']) }}</th>
                                    </tr>
                                    <tr class="table-info">
                                        <th>AVERAGES:</th>
                                        <th></th>
                                        <th>{{ number_format($averages['avg_total_assignments'], 2) }}</th>
                                        <th>{{ number_format($averages['avg_total_open'], 2) }}</th>
                                        <th>{{ number_format($averages['avg_total_completes'], 2) }}</th>
                                        <th>{{ $this->formatCycleTime($averages['avg_cycle_time']) }}</th>
                                    </tr>
                                </tfoot>
                            </table>
                            {{ $appraiser_data->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>