<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Activity</h4>
                </div>
                <div class="card-body">
                    <form  wire:submit.prevent="search" class="row">
                        <div class="col-md-6">
                            <label>Date Range</label>
                            <div class="row">
                                <div class="col-md-6">
                                    <input type="date" name="from_date" id="from_date" class="form-control" wire:model="from_date" value="{{ old('from_date') }}">
                                </div>
                                <div class="col-md-6">
                                    <input type="date" name="to_date" class="form-control" id="to_date" wire:model="to_date" value="{{ old('to_date') }}">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 pt-3" style="text-align:left;">
                            <button type="submit" class="btn btn-primary">Run Report</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
          
        <div class="col-12">
            <div class="row">
              <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Admin Activity Report</h4>
                        </div>
                          
                        <div >
                            <table class='table table-striped datatable dataTable'>
                                <thead>
                                    <tr>
                                        <th>S.No</th>
                                        <th>Name</th>
                                        <th>Activity Type</th>
                                        <th>Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @forelse($activities as $index => $item)
                                    <tr>
                                        <td>{{ $activities->firstItem() + $index }}</td>
                                        <td>{{ $item->user->name }}
                                    @php
                                    $roleMap = [  1 => 'Admin',2 => 'Appraiser',4 => 'Adjuster'];
                                    @endphp

                                     - {{ $roleMap[$item->user->role] ?? '' }}

                                         </td>
                                        <td>{{ $item->activity }}</td>
                                        <td>{{ date('d-M-Y H:i:s A', $item->log_date) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" style="text-align:center;">No activity data found.</td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>
                            {{ $activities->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>