<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>V2 Legacy Insight</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

        <!-- Bootstrap CSS -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.13.1/font/bootstrap-icons.min.css">

        <link rel="stylesheet" href="{{ asset('css/additional.css') }}">
        <link rel="stylesheet" href="{{ asset('css/custom-select.css') }}">

        <!-- Trix Editor -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/trix/2.0.0/trix.min.css">
        <script src="https://cdnjs.cloudflare.com/ajax/libs/trix/2.0.0/trix.umd.min.js"></script>
        <!-- SweetAlert2 -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

        <!-- After the existing CSS links -->
        <!-- <link rel="stylesheet" href="{{ asset('venders/quill/quill.snow.css') }}"> -->




        <link rel="stylesheet" href="{{ asset('css/addon.css') }}">
        <link rel="stylesheet" href="{{ asset('css/main.css') }}">


        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
        
        <!-- Livewire Styles -->
        @livewireStyles

    </head>
    <body x-data x-init="appInit()">
        <!-- Sticky Header -->
        <nav class="navbar navbar-expand-lg sticky-header">
            <div class="container-fluid">

                <!-- Page Title -->
                <span class="navbar-brand mb-0 h1">
                    <img src="{{ asset('images/company-logo-second.png') }}" alt="Legacy Insights" style="max-height: 50px;" class="img-fluid">
                </span>

                <!-- Mobile Toggle -->
                <button class="btn1 btn1-link toptogglebutton" type="button" id="sidebarToggle-unused" onclick="document.querySelector('.custom-navbar').classList.toggle('active')">
                    <i class="bi bi-list"></i>
                </button>

                <!-- Right Side -->
                <div class="navbar-nav ms-auto">
                    <!-- Office admin can login as another office admin from the assigned franchises -->
                    @if (auth()->user()->multiple_franchise && auth()->user()->role == 2)
                    <div class="nav-item">
                        <a class="nav-link d-flex align-items-center pe-0"
                            href="#"
                            id="officesLink"
                            x-data
                            @click.prevent="$dispatch('openOfficesModal')"
                            style="cursor: pointer;">
                                <span class="badge bg-primary ps-2" style="font-size: 16px!important;">
                                    <i class="bi bi-grid"></i> Offices
                                </span>
						</a>
                    </div>
                    @endif

                    @if (auth()->user()->role == 4)
                    <livewire:appraiser.available-status-toggle />
                    @endif

                    <div class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle d-flex align-items-center user-profile-link" href="#" role="button" data-bs-toggle="dropdown">
                            <img src="{{ asset('images/avatar-image.png') }}" alt="Legacy Insights" style="max-height: 30px;" class="img-fluid me-2">
                            <span x-data="{{ json_encode(['name' => auth()->user()->name]) }}" x-text="name" x-on:profile-updated.window="name = $event.detail.name"></span>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#">Profile</a></li>
                            <li><hr class="dropdown-divider"></li>

                           
                                <form method="POST" action="{{ route('logout') }}" id="logout-form">
                                    @csrf
                                    <button type="submit" class="dropdown-item" style="background: none; border: none; width: 100%; text-align: left; padding: 0.25rem 1rem;">
                                        Log Out
                                    </button>
                                </form>
                            </li> 
                        </ul>
                    </div>
                </div>
            </div>
        </nav>


        <!-- Main Container -->
        <div class="container-fluid p-0">
             <livewire:layout.sidebar />

            <div class="row123 g-0 d-flex">               

                <div id="main-content" class="main-content">
                    @yield('content')
                </div>

            </div>
        </div>

        <!-- Sidebar Backdrop for Mobile -->
        <div class="sidebar-backdrop" id="sidebarBackdrop"></div>

        <!-- Livewire Offices Modal Component -->
        <livewire:offices-modal />

        <!-- Bootstrap JS -->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
        <script src="{{ asset('js/custom-select.js') }}"></script>

        <!-- Font Awesome -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">





        <script src="{{ asset('js/addon.js') }}"></script>
        @stack('scripts')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
        <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet"/>
        
        <!-- Livewire Scripts -->
        @livewireScripts

    </body>
</html>

<script>
// Handle offices link click - using event delegation for cross-page navigation
function handleOfficesClick(e) {
    // Check if the clicked element is the offices link or inside it
    if (e.target.closest('#officesLink')) {
        e.preventDefault();
        console.log('Offices link clicked - dispatching event');
        // Dispatch the Livewire event
        Livewire.dispatch('openOfficesModal');
    }
}

// Attach event listener
document.addEventListener('click', handleOfficesClick);

// Re-attach after Livewire navigation
document.addEventListener('livewire:navigated', function() {
    console.log('Livewire navigated - re-attaching event listeners');
    // Remove existing listener and re-add to ensure it works
    document.removeEventListener('click', handleOfficesClick);
    document.addEventListener('click', handleOfficesClick);
});

// Also listen for Livewire initialization
document.addEventListener('livewire:init', function() {
    console.log('Livewire initialized');
});

Livewire.on('notify', (payload) => {
    toastr.options = {
        closeButton: true,
        progressBar: true,
        timeOut: 2000,
    };

    console.log(payload); // should show { message: "Assignment duplicated successfully!" }
    toastr.info(payload[0].message);
});

// Handle delayed redirect
Livewire.on('delayed-redirect', (payload) => {
    let url = payload[0]?.url || '/';
    let delay = payload[0]?.delay || 3000;

    setTimeout(() => {
        window.location.href = url;
    }, delay);
});


</script>
