// Tom Select initialization and configuration
import TomSelect from 'tom-select';

// Initialize Tom Select on all elements with class 'tom-select'
document.addEventListener('DOMContentLoaded', function() {
    // Initialize basic Tom Select
    const basicSelects = document.querySelectorAll('.tom-select');
    basicSelects.forEach(select => {
        new TomSelect(select, {
            plugins: ['dropdown_input'],
            create: false,
            sortField: {
                field: "text",
                direction: "asc"
            }
        });
    });

    // Initialize Tom Select with search
    const searchSelects = document.querySelectorAll('.tom-select-search');
    searchSelects.forEach(select => {
        new TomSelect(select, {
            plugins: ['dropdown_input'],
            create: false,
            sortField: {
                field: "text",
                direction: "asc"
            },
            searchField: ['text', 'value']
        });
    });

    // Initialize Tom Select with multiple selection
    const multiSelects = document.querySelectorAll('.tom-select-multi');
    multiSelects.forEach(select => {
        new TomSelect(select, {
            plugins: ['dropdown_input', 'remove_button'],
            create: false,
            sortField: {
                field: "text",
                direction: "asc"
            },
            searchField: ['text', 'value']
        });
    });

    // Initialize Tom Select with remote data loading
    const remoteSelects = document.querySelectorAll('.tom-select-remote');
    remoteSelects.forEach(select => {
        const url = select.dataset.url;
        if (url) {
            new TomSelect(select, {
                plugins: ['dropdown_input'],
                create: false,
                sortField: {
                    field: "text",
                    direction: "asc"
                },
                load: function(query, callback) {
                    const searchUrl = `${url}?search=${encodeURIComponent(query)}`;
                    fetch(searchUrl)
                        .then(response => response.json())
                        .then(data => {
                            callback(data);
                        })
                        .catch(() => {
                            callback();
                        });
                }
            });
        }
    });
});

// Export for use in other modules
export { TomSelect }; 