function initSidebarToggle_OLD() {
    console.log( jQuery('#sidebarToggle').length + ' 11' );
    const sidebarToggle = document.getElementById('sidebarToggle');
    const sidebar = document.getElementById('sidebar');
    const sidebarBackdrop = document.getElementById('sidebarBackdrop');
    const mainContent = document.getElementById('main-content');

    if (sidebarToggle) {
        sidebarToggle.addEventListener('click', function() {
            sidebar.classList.toggle('show');
            mainContent.classList.toggle('col-lg-9');
            mainContent.classList.toggle('col-md-9');

            if (!sidebar.classList.contains('show')) {
                // mainContent.style.paddingLeft = '0.5rem';
                mainContent.style.width = '100%';
            } else {
                // mainContent.style.paddingLeft = '0';
                mainContent.style.width = '79%';
                sidebar.style.left = '0';
            }
            // sidebarBackdrop.classList.toggle('d-none');
        });
    }
}

var leftSliderShow = true;

// Simple cookie helpers
function setCookie(name, value, days) {
    var expires = "";
    if (days) {
        var date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        expires = "; expires=" + date.toUTCString();
    }
    document.cookie = name + "=" + (value || "") + expires + "; path=/";
}

function getCookie(name) {
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for (var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == ' ') c = c.substring(1, c.length);
        if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length, c.length);
    }
    return null;
}

function initSidebarToggle() {

    function applySidebarState(isOpen) {
        var windowWidth = $(window).width();

        if (isOpen) {
            if (windowWidth > 768) {
                $('#sidebar').css('width', '0%');
                $('#main-content').css('width', '100%');
            } else {
                $('#sidebar').css('width', '0%');
                $('#main-content').css('width', '100%');
            }
            leftSliderShow = true;
        } else {
            $('#sidebar').css('width', '0%');
            $('#main-content').css('width', '100%');
            leftSliderShow = false;
        }
    }

    jQuery('#sidebarToggle').on('click', function() {
        var nextStateIsOpen = !leftSliderShow;
        applySidebarState(nextStateIsOpen);
        setCookie('sidebar_open', nextStateIsOpen ? '1' : '0', 365);
    });

    // Initialize from cookie (default: closed)
    var cookieVal = getCookie('sidebar_open');
    if (cookieVal === '1') {
        applySidebarState(true);
    } else if (cookieVal === '0') {
        applySidebarState(false);
    } else {
        applySidebarState(false);
    }
}


function initQuillEditors() {
    // Guard: Quill library not yet loaded
    if (typeof window.Quill === 'undefined') {
        return;
    }

    const quillElements = document.querySelectorAll('.quill-editor-full');

    quillElements.forEach(element => {
        // Prevent double-initialization when the same textarea persists
        if (element.dataset.quillInitialized === 'true') return;

        // If Livewire replaced the textarea, remove any stale adjacent Quill container
        if (element.nextElementSibling && element.nextElementSibling.classList.contains('quill-container')) {
            element.nextElementSibling.remove();
        }

        // Create a container for Quill
        const container = document.createElement('div');
        container.className = 'quill-container';
        container.style.height = '200px';
        // Prevent Livewire from diffing Quill's DOM
        container.setAttribute('wire:ignore', '');

        // Insert the container after the textarea
        element.parentNode.insertBefore(container, element.nextSibling);

        // Hide the original textarea
        element.style.display = 'none';

        // Initialize Quill
        const quill = new Quill(container, {
            theme: 'snow',
            modules: {
                toolbar: [
                    ['bold', 'italic', 'underline'],
                    ['link', 'blockquote', 'code-block'],
                    [{ 'list': 'ordered' }, { 'list': 'bullet' }],
                    [{ 'header': [1, 2, 3, false] }],
                    ['clean']
                ]
            },
            placeholder: element.placeholder || 'Enter text...'
        });

        // Set initial content if textarea has value
        if (element.value) {
            quill.root.innerHTML = element.value;
        }

        // Sync Quill content with textarea for Livewire
        quill.on('text-change', function () {
            element.value = quill.root.innerHTML;
            element.dispatchEvent(new Event('input', { bubbles: true }));
        });

        // Mark as initialized
        element.dataset.quillInitialized = 'true';
    });

    // Removed auto-toggle to respect cookie state
}

function appInit() {

    initSidebarToggle();
    initQuillEditors();

    // Ensure Quill initializes after all scripts (including quill.js) load
    window.addEventListener('load', function () {
        initQuillEditors();
    });

    // Re-initialize after Livewire DOM updates (Livewire v3)
    document.addEventListener('livewire:load', function () {
        if (window.Livewire && typeof Livewire.hook === 'function') {
            Livewire.hook('message.processed', function () {
                initQuillEditors();
            });
        }
    });

    // Also handle SPA navigations (wire:navigate)
    document.addEventListener('livewire:navigated', function () {
        initQuillEditors();
    });

}

// Make appInit globally available for Alpine.js
window.appInit = appInit;

// Search Filter Container functionality
function initSearchFilterContainer() {
    const searchFilterContainer = document.getElementById('search-filter-container');
    if (!searchFilterContainer) return;

    // Add smooth transition classes
    searchFilterContainer.classList.add('search-filter-transition');
}

// Initialize search filter container after Livewire updates
document.addEventListener('livewire:load', function () {
    if (window.Livewire && typeof Livewire.hook === 'function') {
        Livewire.hook('message.processed', function () {
            initSearchFilterContainer();
        });
    }
});

// Also handle SPA navigations (wire:navigate)
document.addEventListener('livewire:navigated', function () {
    initSearchFilterContainer();
});

// Initialize on page load
document.addEventListener('DOMContentLoaded', function () {
    initSearchFilterContainer();
});
