// Make tooltip globally available
const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))

const ToastError = Swal.mixin({
    toast: true,
    position: 'top-end',
    background: '#a00000', 
    color: '#fff', 
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer);
        toast.addEventListener('mouseleave', Swal.resumeTimer);
         toast.style.width = '400px';
        toast.style.fontSize = '14px';
    }
})

const ToastSuccess = Swal.mixin({
    toast: true,
    position: 'top-end',
    background: '#198754', 
    color: '#fff', 
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer);
        toast.addEventListener('mouseleave', Swal.resumeTimer);
        toast.style.width = '400px';
        toast.style.fontSize = '14px';
    }
})

document.addEventListener("DOMContentLoaded", () => {
    if (typeof Livewire !== 'undefined') {
        Livewire.on('ErrorMessage', (message) => {
            ToastError.fire({ icon: 'error', title: message });
        });

        Livewire.on('SuccessMessage', (message) => {
            ToastSuccess.fire({ icon: 'success', title: message });
        });
    } else {
        console.warn("Livewire is not loaded yet.");
    }
});