// function call for select2
$('.select2').select2();

// script for quill editor and sync quill content to livewire
document.addEventListener('DOMContentLoaded', function () {
    const editors = document.querySelectorAll('.quill-editor-full');

    editors.forEach(function (el) {
        const property = el.dataset.property;

        const quill = new Quill(el, {
            modules: {
                toolbar: [
                    [{ font: [] }, { size: [] }],
                    ['bold', 'italic', 'underline', 'strike'],
                    [{ color: [] }, { background: [] }],
                    [{ script: 'super' }, { script: 'sub' }],
                    [{ list: 'ordered' }, { list: 'bullet' }, { indent: '-1' }, { indent: '+1' }],
                    ['direction', { align: [] }],
                    ['link', 'image', 'video'],
                    ['clean']
                ]
            },
            theme: 'snow'
        });

        // Sync Quill content to Livewire
        quill.on('text-change', function () {
            const content = quill.root.innerHTML;
            if (window.Livewire && property) {
                Livewire.find(el.closest('[wire\\:id]').getAttribute('wire:id')).set(property, content);
            }
        });
    });
});