<?php

namespace Database\Seeders;

use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Create a test user if it doesn't exist
        if (!User::where('email', 'test@example.com')->exists()) {
            User::factory()->create([
                'name' => 'Test User',
                'email' => 'test@example.com',
                'password' => 'password', // Will be hashed by factory
            ]);
            
            $this->command->info('Test user created: test@example.com / password');
        } else {
            $this->command->info('Test user already exists: test@example.com');
        }
        
        // Optionally create additional test users
        // User::factory(10)->create();
    }
}
