<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserColumnPreference extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'page_type',
        'column_order',
    ];

    protected $casts = [
        'column_order' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get or create column preferences for a user and page type
     */
    public static function getPreferences($userId, $pageType, $defaultOrder = [])
    {
        $preference = self::where('user_id', $userId)
            ->where('page_type', $pageType)
            ->first();

        if (!$preference) {
            $preference = self::create([
                'user_id' => $userId,
                'page_type' => $pageType,
                'column_order' => $defaultOrder,
            ]);
        }

        return $preference;
    }

    /**
     * Update column order for a user and page type
     */
    public static function updateOrder($userId, $pageType, $columnOrder)
    {
        return self::updateOrCreate(
            [
                'user_id' => $userId,
                'page_type' => $pageType,
            ],
            [
                'column_order' => $columnOrder,
            ]
        );
    }
}
