<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TotalLossSummary extends Model
{
    use HasFactory;

    protected $table = 'total_loss_summary';

    protected $fillable = [
        'assignment_id',
        'enable_nada',
        'nada_book_value',
        'nada_book_value_2',
        'dealer_quotes',
        'dealer_name1',
        'dealer_name2',
        'dealer_name3',
        'dealer_contact1',
        'dealer_contact2',
        'dealer_contact3',
        'dealer_phone1',
        'dealer_phone2',
        'dealer_phone3',
        'dealer_amount1',
        'dealer_amount2',
        'dealer_amount3',
        'adjustment',
        'upd',
        'comment',
        'salvage_name1',
        'salvage_name2',
        'salvage_name3',
        'salvage_contact1',
        'salvage_contact2',
        'salvage_contact3',
        'salvage_phone1',
        'salvage_phone2',
        'salvage_phone3',
        'salvage_amount1',
        'salvage_amount2',
        'salvage_amount3',
        'tax_rate',
        'include',
    ];

    public function assignment()
    {
        return $this->belongsTo(Assignment::class);
    }
}
