<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class TicketReply extends Model
{
    use HasFactory;

    protected $table = 'ticket_replies';

    protected $fillable = [
        'ticket_id',
        'userid',
        'message',
        'reply_file',
        'created_at',
    ];

    const CREATED_AT = 'created_at';
    const UPDATED_AT = null;

    public function user()
{
    return $this->belongsTo(User::class, 'userid'); 
}

   
}
