<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\TicketReply;
use App\Models\User;

class Ticket extends Model
{
    
     use HasFactory;

    protected $table = 'tickets';

    protected $fillable = [
        'userid',
        'title',
        'description',
        'type',
        'ticket_file',
        'status',
        'priority',
        'closed_by',
        'close_date',
        'created_at',
    ];

    public function replies()
{
    return $this->hasMany(TicketReply::class, 'ticket_id');
}

public function user()
{
    return $this->belongsTo(User::class, 'userid');
}

public function closedBy()
{
    return $this->belongsTo(User::class, 'closed_by');
}



}
