<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class State extends Model
{
    use HasFactory;

    protected $table = 'us_states';

    protected $fillable = [
        'name',
        'code',
        'rate', // added 24/07/2025
        'license_required', // added 24/07/2025
    ];

    public function franchises()
    {
        return $this->hasMany(Franchise::class);
    }
}
