<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PdfPackagingFile extends Model
{
    use HasFactory;

    protected $table = 'pdf_packaging_files';
    
    protected $fillable = [
        'assignment_id',
        'unique_packing_id',
        'file_item',
    ];

    public function file()
    {
        return $this->belongsTo(AssignmentFile::class, 'file_item');
    }
    
}
