<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class InsuranceFee extends Model
{
    use HasFactory;

    protected $table = 'insurance_fee';

    protected $fillable = [
        'insurance_company_id',
        'exclude_from_tax',
        'fee_type',
        'fee_value'
    ];

    private static function defaultFee()
    {

            $fees = DB::table('default_fees')
            ->pluck('insurance_fee_amount', 'fee_name')
            ->toArray();

            return $fees;

       /* return [
            'FIELD APPRAISAL' => 200,
            'PHOTOS ONLY' => 0,
            'SCENE ONLY' => 0,
            'DOI' => 0,
            'MOTO' => 0,
            'TIME AND EXPENSE' => 0,
            'MILEAGE' => 2,
            'TOTAL LOSS' => 0,
            'REMOTE FEE' => 0,
            'SUPPLEMENT' => 0,
            'BROKEN APP' => 0,
            'TOLLS' => 0,
            'SALVAGE BIDS' => 0,
            'MISC' => 0,
            'GLASS CLAIM' => 0,
            'WINDSHIELD CLAIM' => 0,
            'PROPERTY' => 0,
            'HEAVY EQUIPMENT' => 0,
            'RUSH ASSIGNMENT' => 0,
            'UTILITY TRAILER FLAT' => 0,
            'SOFTWARE' => 0,
            'RV FLAT' => 0,
            'FUEL SAMPLE' => 0,
            'LATE FEE OVER 90' => 0,
            'DRIVE TIME' => 0,
            'EXOTIC VEHICLE' => 0,
            'DESK REVIEW' => 0,
            'DESK SUPPLEMENT' => 0,
            'STATEMENT' => 0,
            'ACV REQUEST' => 0,
            'CLOSED FILE' => 0,
            'ADMIN HOURS' => 0,
            'CHUBB MARTINO 1' => 0,
            'CHUBB MARTINO 2' => 0,
            'SUBROGATION' => 0,
            'NO SHOW' => 0,
            'PHONE INSPECTION' => 0,
            'PHONE INSPECTION PHOTOS' => 0,
            'DAILY CAT' => 0,
            'DRIVE IN' => 0,
            'RE KEY' => 0,
            'SPECIALTY' => 0,
            'HOURLY RATE' => 0,
            'DIMINISHED VALUE' => 0,
            'FUEL SURCHARGE' => 0,
            'MECHANICAL BREAKDOWN' => 0,
            'CONDITION FEE' => 0,
            'HE SPECIALTY PHOTO' => 0,
            'HE SPECIALTY MILEAGE' => 0,
            'BROCHURE AUTO' => 0,
            'BROCHURE REC' => 0,
            'ADD PHOTO' => 0,
            'V INSPECTION' => 0,
            'PRE WARANTY INSP' => 0,
            'WARRANTY REPAIR' => 0,
            'SCOPE SPECIALTY' => 0,
            'SPECIALTY SUPP' => 0,
            'AUTO SCOPE AND PHOTOS' => 0,
            'HEAVY EQUIPMENT SCOPE AND PHOTOS' => 0
        ];*/

        
    }

    public static function addDefaultFee( $insurance_company_id )
    {
        $defaultFee = self::defaultFee();

        foreach ($defaultFee as $fee_type => $fee_value) {
            self::firstOrCreate([
                'insurance_company_id' => $insurance_company_id,
                'fee_type' => $fee_type,
            ], [
                'fee_value' => $fee_value,
            ]);
        }
        return true;
    }

}
