<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InsuranceCompany extends Model
{
    use HasFactory;

    protected $table = 'insurance_company';

    protected $fillable = [
        'insurance_contract',
        'insurance_company_type',
        'taxable_client',
        'paying_type',
        'street',
        'city',
        'state_id',
        'postcode',
        'notes',
        'claim_summary_notes',
        'admin_notes',
        'insurance_guidelines',
        'franchise_id',
        'company_name',
        'company_code',
        'phone_number',
        'billing_email_address',
        'email_address',
        'username',
        'company_logo',
        'companycode',
        'tax_id',
        'max_total_loss',
        'connectAccount',
        'street',
        'city',
        'state_id',
        'postcode',
        'coverage_zipcodes',
        'updated_by',
        'mileage_request_email',
        'next_day_fee',
        'next_day_message',
        'vehicle_owner_text',
        'same_day_fee',
        'same_day_message',
        'vehicle_owner_messaage',
        'free_miles',
        'new_assignment_confirmation',
        'mileage_notification',
        'mileage_notification_notes',
        'billing_page_insurance_notes',
        'default_assignment_instructions',
        'new_assignment_notification',
        'completed_assignment_notification',
        'supplement_opened_notification',
        'mileage_request_notification',
        'appointment_set_notification',
        'pdf_package_notification'
    ];

    public function state()
    {
        return $this->belongsTo(State::class);
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function zipcodes()
    {
        return $this->hasMany(FranchiseZipcode::class);
    }

    public function franchise()
    {
        return $this->belongsTo(Franchise::class);
    }
}
