<?php

namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Database\Eloquent\Model;

class Hub extends Model
{
    protected $table = 'hubs';
    protected $primaryKey = 'id';
    public $timestamps = true;

    protected $fillable = [
        'hub_name', 'street', 'city', 'state', 'postcode',
        'hub_latitude', 'hub_longitude', 'insID', 'franchiseID',
    ];

    public function franchise()
    {
        return $this->belongsTo(Franchise::class, 'franchiseID');
    }
}
