<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Franchise extends Model
{
    use HasFactory;

    protected $table = 'franchise';

    protected $fillable = [
        'franchisecode',
        'company_name',
        'first_name',
        'last_name',
        'phone_number',
        'companyfax',
        'email_address',
        'username',
        'company_logo',
        'companycode',
        'tax_id',
        'max_total_loss',
        'connectAccount',
        'street',
        'city',
        'state_id',
        'postcode',
        'coverage_zipcodes',
        'updated_by',
    ];

    public function state()
    {
        return $this->belongsTo(State::class);
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function zipcodes()
    {
        return $this->hasMany(FranchiseZipcode::class);
    }
}
