<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    use HasFactory;

    protected $table = 'company';

    protected $fillable = [
        'companyname',
        'companyemail',
        'companyphone',
        'companyfax',
        'companycode',
        'street',
        'city',
        'state_id',
        'postcode',
        'company_latitude',
        'company_longitude',
        'updated_by'
    ];

    public function state()
    {
        return $this->belongsTo(State::class, 'state_id');
    }
}
