<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BodyShopContacts extends Model
{
    use HasFactory;

    protected $table = 'body_shop_contacts';

    protected $fillable = [
        'body_shop_id',
        'name',
        'email',
    ];

    /**
     * Get the body shop that owns this contact.
     */
    public function bodyShop()
    {
        return $this->belongsTo(BodyShop::class, 'body_shop_id');
    }
}
