<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BodyShop extends Model
{
    use HasFactory;

     protected $table = 'body_shop';
    protected $primaryKey = 'id';
    public $timestamps = true;

    protected $fillable = [
         'location', 'location_name', 'location_phone', 'address', 'city', 'state', 'postcode', 'shop_licence', 'shop_tax_id', 'location_fax', 'franchise_id', 'created_by'
    ];

    /**
     * Get the contacts for this body shop.
     */
    public function contacts()
    {
        return $this->hasMany(BodyShopContacts::class, 'body_shop_id');
    }

    public function stateData()
    {
        return $this->belongsTo(State::class, 'state');
    }
}
