<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssignmentStageCycle extends Model
{
    use HasFactory;

    protected $table = 'assignment_stage_cycles';

    protected $fillable = [
        'assignment_id',
        'from_stage_id',
        'to_stage_id',
        'updated_by',
        'cycle_time',
    ];

    public function assignment()
    {
        return $this->belongsTo(Assignment::class);
    }

    public function fromStage()
    {
        return $this->belongsTo(GlobalStatus::class, 'from_stage_id');
    }

    public function toStage()
    {
        return $this->belongsTo(GlobalStatus::class, 'to_stage_id');
    }
}
