<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssignmentReminder extends Model
{
    use HasFactory;

    protected $table = 'assignment_reminder';

    protected $fillable = [
        'assignment_id',
        'due_date',
        'email_reminder',
        'user_type',
        'user_id',
        'subject',
        'message',
        'created_by',
        'created_date',
        'user_ip',
        'updated_by',
        'emailed'
    ];

    protected $casts = [
        'due_date' => 'date',
        'created_date' => 'date',
        'emailed' => 'boolean',
    ];

    public function assignment()
    {
        return $this->belongsTo(Assignment::class);
    }

    public function assignedUser()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
