<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssignmentPayrolItem extends Model
{
    use HasFactory;

    protected $table = 'assignment_payroll_items';

    protected $fillable = [
        'assignment_id',
        'invoice_id',
        'type',
        'description',
        'appraiser_unit',
        'appraiser_amount',
        'appraiser_id',
        'manual_appraiser_fee',
        'apply_insurance_amount',
        'payroll_date',
        'insurance_free_miles',
        'comment',
        'created_by',
        'paid',
    ];

    public function appraiser()
    {
        return $this->belongsTo(User::class, 'appraiser_id');
    }
}
