<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssignmentMobileUploadRequest extends Model
{
    use HasFactory;

    protected $table = 'assignment_mobile_upload_requests';
    protected $fillable = [
        'assignment_id',
        'send_type',
        'adjuster_email',
        'appraiser_email',
        'owner_email',
        'insurance_email',
        'adjuster_phone',
        'appraiser_phone',
        'owner_phone',
        'insurance_phone',
        'email_phone_value',
        'public_mobile_upload_link',
        'file_submitted',
        'file_submitted_date',
        'created_by'
    ];

    public function assignment()
    {
        return $this->belongsTo(Assignment::class);
    }
}
