<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Assignment;
use App\Models\User;

class AssignmentMileage extends Model
{
    use HasFactory;
    protected $table ='assignment_mileage_request';
    
    protected $fillable = [
 		'assignment_id',
        'requestDate',
        'approvedDate',
        'requestMileage',
        'approveMileage',
        'request_status',
        'request_note',
        'approve_note',
        'requestby',
        'approvedby',
        'denied_by',
        'denied_note',
        'denied_at',
    ];

    public function assignment()
    {
        return $this->belongsTo(Assignment::class);
    }

    public function requestBy()
    {
        return $this->belongsTo(User::class, 'requestby');
    }

    public function approvedBy()
    {
        return $this->belongsTo(User::class, 'approvedby');
    }

    public function deniedBy()
    {
        return $this->belongsTo(User::class, 'denied_by');
    }
}
