<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssignmentMessages extends Model
{
    use HasFactory;
    protected $table = 'assignment_messages';

    protected $fillable = [
        'assignment_id',
        'creator_id',
        'subject',
        'message',
        'predefined_message',
        'admin_email_address',
        'all_email_address',
        'multiple_attachment_file',
        'user_ip',
        'filepath',
        'track_code',
        'email_status',
        'email_opened_time',
        'email_opened_user_ip',
        'admin_only',
        'send_type',
        'adjuster_email',
        'appraiser_email',
        'owner_email',
        'insurance_email',
        'adjuster_phone',
        'appraiser_phone',
        'owner_phone',
        'insurance_phone',
        'seendata',
        'acknowledged',
        'acknowledged_by',
        'acknowledged_date',
    ];

    /**
     * Get the assignment that owns the message.
     */
    public function assignment()
    {
        return $this->belongsTo(Assignment::class);
    }

    /**
     * Get the user who created the message.
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'creator_id');
    }
}
