<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssignmentLog extends Model
{
    use HasFactory;

    protected $table = 'assignment_logs';

    protected $fillable = [
        'assignment_id',
        'user_id',
        'activity',
        'description',
        'user_ip',
    ];

    /**
     * Get the assignment that owns the log.
     */
    public function assignment()
    {
        return $this->belongsTo(Assignment::class);
    }

    /**
     * Get the user who performed the activity.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
} 