<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssignmentInvoiceItem extends Model
{
    use HasFactory;

    protected $table = 'assignment_invoice_item';

    protected $fillable = [
        'assignment_id',
        'invoice_id',
        'description',
        'type',
        'unit',
        'insurance_amount',
        'appraiser_unit',
        'appraiser_amount',
        'appraiser_id',
        'manual_appraiser_fee',
        'apply_insurance_amount',
        'payroll_date',
        'insurance_free_miles',
        'comment',
        'created_by',
    ];

    protected $casts = [
        'insurance_amount' => 'decimal:2',
        'appraiser_amount' => 'decimal:2',
        'payroll_date' => 'date',
        'manual_appraiser_fee' => 'boolean',
        'apply_insurance_amount' => 'boolean',
    ];

    public function assignment()
    {
        return $this->belongsTo(Assignment::class);
    }

    public function invoice()
    {
        return $this->belongsTo(AssignmentInvoice::class, 'invoice_id');
    }

    public function appraiser()
    {
        return $this->belongsTo(User::class, 'appraiser_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
