<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Validation\ValidationException;

class AssignmentInvoice extends Model
{
    use HasFactory;

    protected $table = 'assignment_invoices';

    protected $fillable = [
        'assignment_id',
        'invoiceno',
        'invoice_date',
        'invoice_amount',
        'invoice_status',
        'amount_paid',
        'mark_paid',
        'franchise_payroll',
        'taxpercentage',
        'received_date',
        'gen_date',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($invoice) {
            // Check if an invoice already exists for this assignment
            $existingInvoice = static::where('assignment_id', $invoice->assignment_id)->first();
            if ($existingInvoice) {
                throw ValidationException::withMessages([
                    'assignment_id' => 'An invoice already exists for this assignment. Each assignment can only have one invoice.'
                ]);
            }
        });
    }

    public function assignment()
    {
        return $this->belongsTo(Assignment::class);
    }

    public function items()
    {
        return $this->hasMany(AssignmentInvoiceItem::class, 'invoice_id');
    }
}
