<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppraiserSkills extends Model
{
    use HasFactory;

    protected $table = 'appraiser_skills';

    protected $fillable = ['appraiser_id', 'skill_id', 'parent_skill_id'];

    public function appraiser()
    {
        return $this->belongsTo(User::class, 'appraiser_id');
    }

    public function skill()
    {
        return $this->belongsTo(Skill::class, 'skill_id');
    }

    public function parentSkill()
    {
        return $this->belongsTo(Skill::class, 'parent_skill_id');
    }
}
