<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppraiserGrades extends Model
{
    use HasFactory;

    protected $table = 'appraiser_grades';
    protected $fillable = ['assignment_id', 'appraiser_id', 'grade'];

    public function assignment()
    {
        return $this->belongsTo(Assignment::class);
    }

    public function appraiser() 
    {
        return $this->belongsTo(User::class);
    }
}
