<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AcvWorksheet extends Model
{
    use HasFactory;

    protected $table = 'acv_worksheet';

    protected $fillable = [
        'assignment_id',
        'enable_nada',
        'nada_book_value',
        'dealer_quotes',
        'dealer_name1',
        'dealer_name2',
        'dealer_name3',
        'dealer_contact1',
        'dealer_contact2',
        'dealer_contact3',
        'dealer_phone1',
        'dealer_phone2',
        'dealer_phone3',
        'dealer_amount1',
        'dealer_amount2',
        'dealer_amount3',
        'adjustment',
        'upd',
        'comment',
        'tax_rate',
    ];

    public function assignment()
    {
        return $this->belongsTo(Assignment::class);
    }
}
