<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\DB;
use App\Models\Assignment;
use App\Models\GlobalStatus;
use App\Models\UnitType;
use Livewire\WithPagination;
use Illuminate\Http\Request;
use Carbon\Carbon;

class ReportAverageInvoicereport extends Component
{
    use WithPagination;

    public $records = [];
    public $perPage = 25; // Default items per page

    public $page = 1;

    public $averageInvoiceAmount = 0;
    public $fromDate = '';
    public $toDate = '';
    public $franchise_id = '';
    public $insurance_company_id = '';
    public $adjuster_id = '';
    public $appraiser_id = '';
    public $unit_type = '';
    public $global_status = '';
    public $multiple_franchise = [];


    public function mount()
    {
        // If user is office admin, then limit the records to the multiple franchise only;
        if (auth()->user()->franchise != 0 && auth()->user()->franchise != '' && auth()->user()->franchise != null)
        {
            $franchises = auth()->user()->multiple_franchise;
            $this->multiple_franchise = $franchises 
                ? array_map('trim', explode(',', $franchises)) 
                : [];
            $this->multiple_franchise[] = auth()->user()->franchise;
            $this->multiple_franchise = array_unique(array_filter($this->multiple_franchise));
        }

        $this->fromDate = request()->get('from_date', '');
        $this->toDate = request()->get('to_date', '');
        $this->franchise_id = request()->get('franchise_id', '');
        $this->insurance_company_id = request()->get('insurance_company_id', '');
        $this->adjuster_id = request()->get('adjuster_id', '');
        $this->appraiser_id = request()->get('appraiser_id', '');
        $this->unit_type = request()->get('unit_type', '');
        $this->global_status = request()->get('global_status', '');
    }

    public function render()
    {
        $where = "a.file_no != '' AND ai.invoice_amount > 0 AND a.id = ai.assignment_id";
        if($this->fromDate != '' && $this->toDate != ''){
            $where .= " AND a.created_date BETWEEN '{$this->fromDate} 00:00:00' AND '{$this->toDate} 23:59:59'";
        }
        elseif( isset($this->fromDate) && $this->fromDate != '')
        {
            $from_date = $this->fromDate . ' 00:00:00';
            $where .= " AND a.created_date >= '$from_date' ";
        }
        elseif( isset($this->toDate) && $this->toDate != '')
        {
            $to_date = $this->toDate . ' 23:59:59';
            $where .= " AND a.created_date <= '$to_date' ";
        }

        if (!empty($this->franchise_id)) 
        {
            $idList = $this->franchise_id;
            $where .= " AND a.franchise_id IN ($idList)";
        }

        if (!empty($this->insurance_company_id)) 
        {
            $where .= " AND a.insurance_company_id IN ({$this->insurance_company_id})";
        }

        if (!empty($this->adjuster_id)) 
        {
            $where .= " AND a.adjuster_id IN ({$this->adjuster_id})";
        }

        if (!empty($this->appraiser_id)) 
        {
            $where .= " AND a.appraiser_id IN ({$this->appraiser_id})";
        }

        if (!empty($this->unit_type)) 
        {
            $unit_type_ids = explode(',', $this->unit_type);
            $unit_type_ids = array_map(function($id) {
                return "'$id'";
            }, $unit_type_ids);
            $where .= " AND a.unit_type_id IN (" . implode(',', $unit_type_ids) . ")";
        }

        if (!empty($this->global_status)) 
        {
            $global_status_ids = explode(',', $this->global_status);
            $global_status_ids = array_map(function($id) {
                return "'$id'";
            }, $global_status_ids);
            $where .= " AND a.status_id IN (" . implode(',', $global_status_ids) . ")";
        }

        if (count($this->multiple_franchise) > 0) {
            $where .= " AND a.franchise_id IN (" . implode(',', $this->multiple_franchise) . ")";
        }

        $qry = "SELECT a.*, ai.invoice_amount, ai.invoiceno  FROM assignments a, assignment_invoices ai WHERE $where ORDER BY a.id asc";

        // Get total count for pagination
        $totalRecords = DB::select("SELECT COUNT(*) as total FROM assignments a, assignment_invoices ai WHERE $where")[0]->total;
        
        // Get paginated records
        $offset = ($this->page - 1) * $this->perPage;
        $qry .= " LIMIT {$this->perPage} OFFSET {$offset}";
        $this->records = DB::select($qry);

        // Calculate sum and average of invoice amounts
        $average_query = "SELECT SUM(ai.invoice_amount) as total_invoice_amount, 
                            AVG(ai.invoice_amount) as average_invoice_amount, 
                            COUNT(ai.invoice_amount) as total_invoices FROM 
                            assignments a, assignment_invoices ai WHERE $where"; 

        $sum_avg_data = DB::select($average_query)[0];

        $total_invoice_amount = $sum_avg_data->total_invoice_amount ?? 0;
        $this->averageInvoiceAmount = $sum_avg_data->average_invoice_amount ?? 0;
        $total_invoices = $sum_avg_data->total_invoices ?? 0;

        return view('livewire.report-average-invoicereport', [
            'totalRecords' => $totalRecords,
            'totalPages' => ceil($totalRecords / $this->perPage),
            'currentPage' => $this->page,
            'perPage' => $this->perPage
        ]);
    }

    public function nextPage()
    {
        $this->page++;
    }

    public function previousPage()
    {
        if ($this->page > 1) {
            $this->page--;
        }
    }

    public function goToPage($page)
    {
        $this->page = $page;
    }

    public function updatedPerPage()
    {
        $this->resetPage();
    }
}

