<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\DB;
use App\Models\Assignment;
use App\Models\GlobalStatus;
use App\Models\UnitType;
use Livewire\WithPagination;
use Illuminate\Http\Request;
use Carbon\Carbon;

class MultiReport extends Component
{
    use WithPagination;

    public $from_date;
    public $to_date;
    public $franchise_id = [];
    public $insurance_company_id = [];
    public $adjuster_id = [];
    public $appraiser_id = [];
    public $selectedReport = 'report-stage-lifecycle';
    public $unit_types = [];
    public $unit_type = '';
    public $global_statuses = [];
    public $global_status = '';
    public $multiple_franchise = [];

    public function mount()
    {
        // If user is office admin, then limit the records to the multiple franchise only;
        if (auth()->user()->franchise != 0 && auth()->user()->franchise != '' && auth()->user()->franchise != null)
        {
            $franchises = auth()->user()->multiple_franchise;
            $this->multiple_franchise = $franchises 
                ? array_map('trim', explode(',', $franchises)) 
                : [];
            $this->multiple_franchise[] = auth()->user()->franchise;
            $this->multiple_franchise = array_unique(array_filter($this->multiple_franchise));
        }

        $this->franchise_id = [];
        $this->insurance_company_id = [];
        $this->adjuster_id = [];
        $this->appraiser_id = [];
    }

    public function goToReport()
    {        
        if (empty($this->selectedReport)) {
            session()->flash('error', 'Please select a report.');
            return;
        }

        if (empty($this->from_date) || empty($this->to_date)) {
            session()->flash('error', 'Please select specific date range.');
            return;
        }

        $params = [
            'from_date' => $this->from_date,
            'to_date' => $this->to_date,
            'franchise_id' => $this->franchise_id,
            'insurance_company_id' => $this->insurance_company_id,
            'adjuster_id' => $this->adjuster_id,
            'appraiser_id' => $this->appraiser_id,
            'unit_type' => $this->unit_type,
            'global_status' => $this->global_status,
        ];

        $queryString = http_build_query($params);
        $url = route($this->selectedReport) . '?' . $queryString;

        return redirect()->to($url);
    }

    public function render()
    {
        // $allAdjusters = DB::table('users')->where('role', '4')->get();
        $allAdjusters = DB::select(" SELECT * FROM users join insurance_company on insurance_company.id=users.insurance_company_id AND users.role = 4   order by users.name asc ");
        $allAppraisers = DB::select(" SELECT * FROM users WHERE users.role=2   order by users.name asc ");
        
        if (count($this->multiple_franchise) > 0) {
            $allFranchises = DB::table('franchise')->orderBy('franchisecode', 'asc')->whereIn('id', $this->multiple_franchise)->get();
        } else {
            $allFranchises = DB::table('franchise')->orderBy('franchisecode', 'asc')->get();
        }
        
        $allInsurances = DB::table('insurance_company')->orderBy('company_name', 'asc')->get();
        $this->unit_types = UnitType::all();
        $this->global_statuses = GlobalStatus::all();

        return view('livewire.multi-report', [
            'franchises' => $allFranchises,
            'insuranceCompanies' => $allInsurances,
            'adjusters' => $allAdjusters,
            'appraisers' => $allAppraisers
        ]);
    }
}

