<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\DB;
use App\Models\Assignment;
use App\Models\GlobalStatus;
use App\Models\UnitType;
use Livewire\WithPagination;
use Illuminate\Http\Request;
use Carbon\Carbon;

class FileAgedReport extends Component
{
	use WithPagination;

    protected $paginationTheme = 'bootstrap';

    public $days = 1;
    public $insID;
    public $appraiserID;
    public $office;
	public $allFranchises = [];
    public $allInsurances = [];
    public $allAdjusters = [];
    public $allAppraisers = [];
	public $insurance;
    public $franchise;
    public $adjuster;
    public $appraiser;
	public $unit_types = [];
    public $unit_type = '';
    public $global_statuses = [];
    public $global_status = '';
	public $multiple_franchise = [];

    public $completed_status_id;
    public $closed_status_id;
    public $cancelled_status_id;
    public $supplement_status_id;

    // function for filter form
    public function search()
    {
        $this->resetPage(); 
		$this->refreshOptions();
    }

	public function mount()
    {
		// If user is office admin, then limit the records to the multiple franchise only;
        if (auth()->user()->franchise != 0 && auth()->user()->franchise != '' && auth()->user()->franchise != null)
        {
            $franchises = auth()->user()->multiple_franchise;
            $this->multiple_franchise = $franchises 
                ? array_map('trim', explode(',', $franchises)) 
                : [];
            $this->multiple_franchise[] = auth()->user()->franchise;
            $this->multiple_franchise = array_unique(array_filter($this->multiple_franchise));
        }

        $this->refreshOptions();
    }

	public function getReportData()
	{
        $tempRecord = GlobalStatus::whereRaw('LOWER(status) = ?', [strtolower('Completed')])->first();
        if ($tempRecord) {
            $this->completed_status_id = $tempRecord->id;
        }

        $tempRecord = GlobalStatus::whereRaw('LOWER(status) = ?', [strtolower('Closed')])->first();
        if ($tempRecord) {
            $this->closed_status_id = $tempRecord->id;
        }

        $tempRecord = GlobalStatus::whereRaw('LOWER(status) = ?', [strtolower('Cancelled')])->first();
        if ($tempRecord) {
            $this->cancelled_status_id = $tempRecord->id;
        }

        $tempRecord = GlobalStatus::whereRaw('LOWER(status) = ?', [strtolower('Supplement')])->first();
        if ($tempRecord) {
            $this->supplement_status_id = $tempRecord->id;
        }

		// Get assignments that have been opened for X days
		$query = Assignment::with(['franchise', 'insurancecompany', 'adjuster', 'appraiser', 'phase'])
					->where('status_id', '!=', $this->completed_status_id)
					->where('status_id', '!=', $this->closed_status_id)
					->where('status_id', '!=', $this->cancelled_status_id)
					->where('status_id', '!=', $this->supplement_status_id)
					->whereRaw('DATEDIFF(NOW(), assignments.created_date) >= ?', [$this->days]);

		// Apply other filters
		$query->when($this->insurance, function ($query) {
			$ids = explode(',', $this->insurance);
			$query->whereIn('assignments.insurance_company_id', $ids);
		})
		->when($this->appraiser, function ($query) {
			$ids = explode(',', $this->appraiser);
			$query->whereIn('assignments.appraiser_id', $ids);
		})
		->when($this->adjuster, function ($query) {
			$ids = explode(',', $this->adjuster);
			$query->whereIn('assignments.adjuster_id', $ids);
		})
		->when($this->franchise, function ($query) {
			$ids = explode(',', $this->franchise);
			$query->whereIn('assignments.franchise_id', $ids);
		})
		->when($this->unit_type, function ($query) {
			$ids = explode(',', $this->unit_type);
			$query->whereIn('assignments.unit_type_id', $ids);
		})
		->when($this->global_status, function ($query) {
			$ids = explode(',', $this->global_status);
			$query->whereIn('assignments.status_id', $ids);
		});

		if (count($this->multiple_franchise) > 0) {
			$query->whereIn('assignments.franchise_id', $this->multiple_franchise);
		}

		$query->where('assignments.id', '!=', '')
		->orderBy('assignments.id', 'desc');

		return $query->paginate(25);
	}

    // function for render data on the page
    public function render()
	{

		if (count($this->multiple_franchise) > 0) {
			$franchise = DB::table('franchise')->whereIn('id', $this->multiple_franchise)->get()->toArray();
		} else {
			$franchise = DB::table('franchise')->get()->toArray();
		}
	    $insCom = DB::table('insurance_company')->get()->toArray();
	    $users = DB::table('users')->get()->toArray();

	    return view('livewire.file-aged-report', [
	        'report_data' => $this->getReportData(),
	        'franchise' => $franchise,
	        'insCom' => $insCom,
	        'users' => $users
	    ]);
	}

	public function refreshOptions()
    {
        // Refresh the options data
        $this->allInsurances = DB::table('insurance_company')->orderBy('company_name', 'asc')->get();
        $this->allAdjusters = DB::select(" SELECT * FROM users join insurance_company on insurance_company.id=users.insurance_company_id AND users.role=4   order by users.name asc ");
		if (count($this->multiple_franchise) > 0) {
			$this->allFranchises = DB::table('franchise')->orderBy('franchisecode', 'asc')->whereIn('id', $this->multiple_franchise)->get();
		} else {
			$this->allFranchises = DB::table('franchise')->orderBy('franchisecode', 'asc')->get();
		}
        $this->allAppraisers = DB::select(" SELECT * FROM users WHERE users.role=2   order by users.name asc ");
        $this->unit_types = UnitType::all();
        $this->global_statuses = GlobalStatus::all();

    }
}

