<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\DB;
use App\Models\Assignment;
use App\Models\GlobalStatus;
use App\Models\UnitType;
use Livewire\WithPagination;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\AssignmentLog;

class AdminActivity extends Component
{
    use WithPagination;

    public $from_date;
    public $to_date;
    protected $paginationTheme = 'bootstrap';

  
    public function search()
    {
        $this->resetPage(); 
    }

    public function render()
    {
        $from = $this->from_date ? strtotime($this->from_date) : null;
        $to = $this->to_date ? strtotime($this->to_date) : null;
        $query = AssignmentLog::with('user')
            ->when($from && $to, function ($q) use ($from, $to) {
                $q->whereBetween('log_date', [$from, $to]);
            })
            ->join('users', 'assignment_logs.user_id', '=', 'users.id') 
            ->where('users.role', 1)->orderBy('assignment_logs.id', 'desc');

        $activities = $query->paginate(25);

        return view('livewire.admin-activity', [
            'activities' => $activities, 
        ]);
    }
}

